/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.commands.executors.boxes;

import com.xericker.mysteryboxes.commands.Command;
import com.xericker.mysteryboxes.commands.CommandInterface;
import com.xericker.mysteryboxes.commands.CommandUtils;
import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import utils.PluginUtils;

public class ExecuteBoxUpdaterAll
implements CommandInterface {
    @Override
    public boolean execute(CommandSender commandSender, Command command, String[] stringArray) {
        if (stringArray.length < 3) {
            CommandUtils.sendMessage(commandSender, "Oops! Some arguments are missing!", command);
            return false;
        }
        if (!PluginUtils.isInteger(stringArray[2])) {
            CommandUtils.sendMessage(commandSender, "The [amount] argument must be a number!", command);
            return false;
        }
        Box box = BoxManager.getBox(stringArray[1]);
        if (box == null) {
            CommandUtils.sendMessage(commandSender, new String[]{"Could not find the specified box!", "", "\u00a7eType \u00a7b/mb " + Command.LISTBOXES.getName() + " \u00a7efor the list of Mystery Boxes"});
            return false;
        }
        int n = Integer.parseInt(stringArray[2]);
        ArrayList<PlayerData> arrayList = new ArrayList<PlayerData>();
        for (Player object : Bukkit.getOnlinePlayers()) {
            arrayList.add(PlayerDataManager.getData(object.getUniqueId()));
        }
        switch (command) {
            case SETBOXESALL: {
                for (PlayerData playerData : arrayList) {
                    playerData.setBoxes(box, n);
                }
                for (String string : ConfigParser.getStringList(LanguageValue.BOX_SET_ALL)) {
                    String string2 = string.replace("{AMOUNT}", String.valueOf(n));
                    commandSender.sendMessage(string2);
                }
                break;
            }
            case ADDBOXESALL: {
                for (PlayerData playerData : arrayList) {
                    playerData.setBoxes(box, playerData.getBoxes(box) + n);
                }
                for (String string : ConfigParser.getStringList(LanguageValue.BOX_ADD_ALL)) {
                    String string3 = string.replace("{AMOUNT}", String.valueOf(n));
                    commandSender.sendMessage(string3);
                }
                break;
            }
            case REMOVEBOXESALL: {
                for (PlayerData playerData : arrayList) {
                    playerData.setBoxes(box, playerData.getBoxes(box) - n);
                }
                for (String string : ConfigParser.getStringList(LanguageValue.BOX_REMOVE_ALL)) {
                    String string4 = string.replace("{AMOUNT}", String.valueOf(n));
                    commandSender.sendMessage(string4);
                }
                break;
            }
        }
        return false;
    }
}

