/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.config.handlers;

import com.xericker.mysteryboxes.Main;
import libraries.ConfigAPI;
import org.bukkit.configuration.file.FileConfiguration;

public enum ConfigFile {
    CONFIG,
    LANGUAGE,
    VAULTS,
    SONG_PACK,
    PLAYER_DATA,
    PLUGIN_DATA,
    VAULT_DATA;

    private static final String DATA_FOLDER_PATH;
    private static final String DATA_FOLDER_GENERAL_PATH;
    private static final String CONFIG_FOLDER_PATH;

    public String getId() {
        return this.name().toLowerCase().replace("_", "-");
    }

    public FileConfiguration getFile() {
        ConfigAPI.Config config = ConfigAPI.getConfig(this.getId());
        if (config == null) {
            return null;
        }
        return config.getFileConfig();
    }

    public void saveFile() {
        ConfigAPI.saveConfig(this.getId());
    }

    public static void registerFiles() {
        for (ConfigFile configFile : ConfigFile.values()) {
            String string = configFile.getId();
            if (ConfigAPI.getConfig(string) != null) {
                ConfigAPI.saveConfig(string);
                ConfigAPI.unregisterConfig(string);
            }
            ConfigAPI.registerConfig(string, string + ".yml", configFile.getFilePath(), true, Main.getPlugin());
        }
    }

    public String getFilePath() {
        if (this == VAULT_DATA || this == PLAYER_DATA || this == PLUGIN_DATA) {
            return DATA_FOLDER_GENERAL_PATH;
        }
        return CONFIG_FOLDER_PATH;
    }

    static {
        DATA_FOLDER_PATH = Main.getPlugin().getDataFolder().getPath();
        DATA_FOLDER_GENERAL_PATH = DATA_FOLDER_PATH + "/data/general-data";
        CONFIG_FOLDER_PATH = DATA_FOLDER_PATH + "/config";
    }
}

