/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.config.handlers;

import com.xericker.mysteryboxes.config.files.ConfigValue;
import com.xericker.mysteryboxes.config.handlers.ConfigFile;
import com.xericker.mysteryboxes.config.handlers.ConfigObject;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import libraries.ConfigAPI;
import libraries.iridium.IridiumColorAPI;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import utils.MessageUtils;

public class ConfigParser {
    private ConfigParser() {
    }

    public static Boolean getBoolean(Enum<?> enum_) {
        return Boolean.parseBoolean(ConfigParser.getString(enum_));
    }

    public static Integer getInt(Enum<?> enum_) {
        String string = ConfigParser.getString(enum_);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public static Float getFloat(Enum<?> enum_) {
        String string = ConfigParser.getString(enum_);
        if (string == null) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(Float.parseFloat(string));
    }

    public static Double getDouble(Enum<?> enum_) {
        String string = ConfigParser.getString(enum_);
        if (string == null) {
            return 0.0;
        }
        return Double.parseDouble(string);
    }

    private static String translate(String string) {
        if (string == null) {
            return string;
        }
        if (string.contains("%center%")) {
            string = string.replace("%center%", "");
            string = MessageUtils.formatCenter(string);
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        string = IridiumColorAPI.process(string);
        return string;
    }

    public static String getString(Enum<?> enum_) {
        ConfigObject configObject = (ConfigObject)((Object)enum_);
        ConfigAPI.Config config = ConfigAPI.getConfig(configObject.getConfigId());
        if (config == null) {
            return null;
        }
        FileConfiguration fileConfiguration = config.getFileConfig();
        String string = configObject.getPath();
        return ConfigParser.translate(fileConfiguration.getString(string));
    }

    public static Map<ConfigValue, String> getStringValues(Enum<?>[] enumArray) {
        EnumMap<ConfigValue, String> enumMap = new EnumMap<ConfigValue, String>(ConfigValue.class);
        for (Enum<?> enum_ : enumArray) {
            enumMap.put((ConfigValue)enum_, ConfigParser.getString(enum_));
        }
        return enumMap;
    }

    public static List<String> getStringList(Enum<?> enum_) {
        ConfigObject configObject = (ConfigObject)((Object)enum_);
        ConfigAPI.Config config = ConfigAPI.getConfig(configObject.getConfigId());
        if (config == null) {
            return new ArrayList<String>();
        }
        FileConfiguration fileConfiguration = config.getFileConfig();
        String string = configObject.getPath();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : fileConfiguration.getStringList(string)) {
            arrayList.add(ConfigParser.translate(string2));
        }
        return arrayList;
    }

    public static String getString(String string) {
        FileConfiguration fileConfiguration = ConfigFile.LANGUAGE.getFile();
        if (fileConfiguration == null) {
            return null;
        }
        return ConfigParser.getString(fileConfiguration, string);
    }

    public static String getString(FileConfiguration fileConfiguration, String string) {
        if (fileConfiguration == null) {
            return null;
        }
        return ConfigParser.translate(fileConfiguration.getString(string));
    }

    public static List<String> getStringList(String string) {
        FileConfiguration fileConfiguration = ConfigFile.LANGUAGE.getFile();
        if (fileConfiguration == null) {
            return new ArrayList<String>();
        }
        return ConfigParser.getStringList(fileConfiguration, string);
    }

    public static List<String> getStringList(FileConfiguration fileConfiguration, String string) {
        if (fileConfiguration == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : fileConfiguration.getStringList(string)) {
            arrayList.add(ConfigParser.translate(string2));
        }
        return arrayList;
    }
}

