/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.effects.executors;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.core.effects.EffectStatus;
import com.xericker.mysteryboxes.handlers.data.loots.LootReveal;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ConfettiEffect {
    public boolean enabled;
    public int duration;
    public Material itemType;
    public boolean itemGlow;
    private EffectStatus status;

    public ConfettiEffect(FileConfiguration fileConfiguration, LootReveal lootReveal) {
        try {
            Object object = "effects-settings.";
            object = (String)object + (lootReveal == LootReveal.DISCOVERED ? "loot-discovered" : "loot-duplicated");
            object = (String)object + ".confetti-effect.";
            this.enabled = fileConfiguration.getBoolean((String)object + "enabled");
            this.duration = fileConfiguration.getInt((String)object + "duration");
            this.itemGlow = fileConfiguration.getBoolean((String)object + "item-glow");
            String string = fileConfiguration.getString((String)object + "item-type");
            if (string != null) {
                this.itemType = Material.matchMaterial((String)string);
            }
            this.status = EffectStatus.VALID;
            if (this.enabled && (this.duration == 0 || this.itemType == null)) {
                this.status = EffectStatus.INVALID;
            }
        }
        catch (Exception exception) {
            this.status = EffectStatus.INVALID;
        }
    }

    public EffectStatus getStatus() {
        return this.status;
    }

    public void playEffect(final Location location) {
        new BukkitRunnable(){
            int effectStep = 0;
            int stayStep = 0;
            ItemStack itemStack;
            List<Item> items;
            {
                this.itemStack = new ItemStack(ConfettiEffect.this.itemType);
                this.items = new ArrayList<Item>();
            }

            public void run() {
                ++this.stayStep;
                if (this.stayStep == (ConfettiEffect.this.duration + 4) * 6) {
                    for (Item item : this.items) {
                        item.remove();
                    }
                    this.cancel();
                    return;
                }
                ++this.effectStep;
                if (this.effectStep > ConfettiEffect.this.duration * 6) {
                    return;
                }
                if (ConfettiEffect.this.itemGlow) {
                    this.itemStack.addUnsafeEnchantment(Enchantment.SILK_TOUCH, 1);
                }
                Item item = location.getWorld().dropItem(location, this.itemStack);
                item.setMetadata(Main.getMetadataValue(), (MetadataValue)Main.getFixedMetadataValue());
                this.items.add(item);
                Vector vector = new Vector((Main.getRandom().nextDouble() - 0.5) / 2.15, 0.15 + Main.getRandom().nextDouble() / 3.0, (Main.getRandom().nextDouble() - 0.5) / 2.15);
                item.setVelocity(vector);
                location.getWorld().playSound(location, Sound.ENTITY_CHICKEN_EGG, 1.0f, 1.0f);
                location.getWorld().playSound(location, Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 2.0f);
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 3L);
    }
}

