/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.effects.executors;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.core.effects.EffectStatus;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.handlers.data.loots.LootReveal;
import data.FireworkData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import misc.EffectsParser;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import utils.WorldUtils;

public class FireworkShowEffect {
    public boolean enabled;
    public int amount;
    public int period;
    public boolean random;
    public List<FireworkData> fireworks;
    private EffectStatus status;

    public FireworkShowEffect(FileConfiguration fileConfiguration, LootReveal lootReveal) {
        try {
            Object object = "effects-settings.";
            object = (String)object + (lootReveal == LootReveal.DISCOVERED ? "loot-discovered" : "loot-duplicated");
            object = (String)object + ".firework-show-effect.";
            this.enabled = fileConfiguration.getBoolean((String)object + "enabled");
            this.amount = fileConfiguration.getInt((String)object + "amount");
            this.period = fileConfiguration.getInt((String)object + "period");
            this.random = fileConfiguration.getBoolean((String)object + "random");
            this.fireworks = new ArrayList<FireworkData>();
            for (String string : fileConfiguration.getStringList((String)object + "fireworks")) {
                this.fireworks.add(EffectsParser.parseFirework(string));
            }
            this.status = EffectStatus.VALID;
            if (this.enabled && (this.amount == 0 || this.period == 0)) {
                this.status = EffectStatus.INVALID;
            }
        }
        catch (Exception exception) {
            this.status = EffectStatus.INVALID;
        }
    }

    public EffectStatus getStatus() {
        return this.status;
    }

    public void playEffect(OpenEvent openEvent, final Location location) {
        int n = this.amount / this.period;
        n = n * 20 + 20;
        openEvent.setRevealDelay(n);
        new BukkitRunnable(){
            int effectStep = 0;

            public void run() {
                ++this.effectStep;
                if (this.effectStep == FireworkShowEffect.this.amount) {
                    this.cancel();
                    return;
                }
                FireworkData fireworkData = null;
                if (!FireworkShowEffect.this.fireworks.isEmpty()) {
                    fireworkData = FireworkShowEffect.this.fireworks.get(Main.getRandom().nextInt(FireworkShowEffect.this.fireworks.size()));
                }
                if (FireworkShowEffect.this.random) {
                    FireworkEffect.Type type = FireworkEffect.Type.values()[Main.getRandom().nextInt(FireworkEffect.Type.values().length)];
                    boolean bl = Main.getRandom().nextBoolean();
                    boolean bl2 = Main.getRandom().nextBoolean();
                    Color color = Color.fromBGR((int)Main.getRandom().nextInt(255), (int)Main.getRandom().nextInt(255), (int)Main.getRandom().nextInt(255));
                    Color color2 = Color.fromBGR((int)Main.getRandom().nextInt(255), (int)Main.getRandom().nextInt(255), (int)Main.getRandom().nextInt(255));
                    fireworkData = new FireworkData(type, bl, bl2, 1, Collections.singletonList(color), Collections.singletonList(color2));
                }
                WorldUtils.spawnFirework(location, fireworkData.getType(), fireworkData.isFlicker(), fireworkData.isTrail(), fireworkData.getPower(), fireworkData.getColors(), fireworkData.getFadeColors());
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, (long)this.period);
    }
}

