/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.crafting;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.events.opening.utils.BoxEntity;
import com.xericker.mysteryboxes.core.vaults.Vault;
import com.xericker.mysteryboxes.core.vaults.VaultAction;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.placeholders.GeneralPlaceholders;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import com.xericker.mysteryboxes.playerdata.stats.Statistic;
import com.xericker.mysteryboxes.playerdata.stats.Timestamp;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import utils.LocationUtils;
import utils.PlayerUtils;
import utils.PluginUtils;

public class CraftEvent
extends BukkitRunnable {
    private Player player;
    private Box box;
    private Vault vault;
    private int eventStep;
    private int soundStep;
    private boolean eventCancelled;
    private boolean eventFinished;
    private ArmorStand anvilEntity;
    private ArmorStand boxEntity;

    public CraftEvent(Player player, Box box, Vault vault) {
        this.player = player;
        this.box = box;
        this.vault = vault;
    }

    public void craftBox() {
        PlayerData playerData = PlayerDataManager.getData(this.player);
        Location location = this.getEventLocation();
        playerData.setVaultAction(VaultAction.CRAFTING);
        if (this.vault != null) {
            this.vault.setVaultAction(VaultAction.CRAFTING);
        }
        location.setYaw(this.player.getLocation().getYaw() - 90.0f);
        this.anvilEntity = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
        this.anvilEntity.getEquipment().setHelmet(new ItemStack(Material.ANVIL));
        BoxEntity.updateEntity(this.anvilEntity);
        location.setYaw(this.player.getLocation().getYaw() - 180.0f);
        this.boxEntity = (ArmorStand)location.getWorld().spawn(location.clone().add(0.0, 1.3, 0.0), ArmorStand.class);
        this.boxEntity.getEquipment().setHelmet(new ItemStack(Material.MAGMA_BLOCK));
        this.boxEntity.setSmall(true);
        BoxEntity.updateEntity(this.boxEntity);
        this.runTaskTimer((Plugin)Main.getPlugin(), 0L, 1L);
    }

    public void run() {
        PlayerData playerData = PlayerDataManager.getData(this.player);
        Location location = this.boxEntity.getEyeLocation().add(0.0, 0.4, 0.0);
        if (!this.player.isOnline() || this.eventFinished) {
            this.anvilEntity.remove();
            this.boxEntity.remove();
            playerData.setVaultAction(null);
            if (this.vault != null) {
                this.vault.setVaultAction(null);
            }
            this.cancel();
            return;
        }
        ++this.soundStep;
        if (this.soundStep == 0 && this.eventStep < 50) {
            this.boxEntity.getWorld().playSound(this.boxEntity.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 0.25f, 0.0f);
            this.soundStep = -5;
        }
        if (this.eventStep == 0 || this.eventStep == 5 || this.eventStep == 10 || this.eventStep == 30) {
            this.boxEntity.getWorld().playSound(location, Sound.BLOCK_ANVIL_LAND, 0.5f, Main.getRandom().nextFloat() + 1.0f);
            this.boxEntity.getWorld().playSound(location, Sound.ENTITY_ITEM_BREAK, 0.5f, Main.getRandom().nextFloat() + 1.0f);
            this.boxEntity.getWorld().spawnParticle(Particle.LAVA, location, 5, 0.0, 0.0, 0.0, 1.0);
        }
        if (this.eventStep >= 50) {
            this.boxEntity.getWorld().spawnParticle(Particle.CRIT_MAGIC, location, 2, 0.25, 0.25, 0.25, 0.0);
        }
        if (this.eventStep == 50) {
            Object object;
            Location location22;
            for (Location location22 : LocationUtils.getCircle(this.boxEntity.getLocation(), 0.5, 50)) {
                object = location22.toVector().subtract(this.boxEntity.getLocation().toVector()).normalize();
                this.boxEntity.getWorld().spawnParticle(Particle.FLAME, location, 0, object.getX(), object.getY(), object.getZ(), 0.2);
            }
            for (Location location22 : LocationUtils.getCircle(this.boxEntity.getLocation(), 0.5, 100)) {
                object = location22.toVector().subtract(this.boxEntity.getLocation().toVector()).normalize();
                this.boxEntity.getWorld().spawnParticle(Particle.SMOKE_LARGE, location, 0, object.getX(), object.getY(), object.getZ(), 0.6);
            }
            Object object2 = this.box.getBoxSettings().head;
            object2 = GeneralPlaceholders.translate((Object)this.player, (String)object2);
            location22 = new ItemStack(this.box.getBoxSettings().type);
            if (!PluginUtils.isEmpty((String)object2)) {
                location22 = PlayerUtils.parseHead((String)object2);
            }
            BoxEntity.updateEntity(this.boxEntity, this.box.getBoxSettings().name);
            this.boxEntity.getEquipment().setHelmet((ItemStack)location22);
            this.boxEntity.getWorld().playSound(location, Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
            this.boxEntity.getWorld().strikeLightningEffect(location);
            playerData.setBoxes(this.box, playerData.getBoxes(this.box) + 1);
            playerData.setDust(playerData.getDust() - this.box.getCraftingSettings().dustCost);
            playerData.setStatistic(Statistic.BOXES_CRAFTED, playerData.getStatistic(Statistic.BOXES_CRAFTED) + 1L);
            playerData.setTimestamp(Timestamp.BOX_CRAFT, System.currentTimeMillis());
            for (String string : ConfigParser.getStringList(LanguageValue.BOX_CRAFTED)) {
                string = GeneralPlaceholders.translate((Object)this.player, this.box, string);
                this.player.sendMessage(string);
            }
        }
        if (this.eventStep == 150) {
            this.eventFinished = true;
        }
        ++this.eventStep;
    }

    public Location getEventLocation() {
        Location location = this.vault != null && this.vault.getVaultLoc() != null ? this.vault.getVaultLoc().add(0.5, -0.5, 0.5) : this.player.getLocation().subtract(0.0, 1.3, 0.0);
        location.setYaw(this.player.getLocation().getYaw() - 180.0f);
        return location;
    }

    public boolean isEventCancelled() {
        return this.eventCancelled;
    }

    public void cancelEvent() {
        this.eventCancelled = true;
    }
}

