/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.opening.loots;

import com.xericker.mysteryboxes.handlers.data.loots.Loot;
import com.xericker.mysteryboxes.handlers.data.loots.LootReveal;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import org.bukkit.entity.Player;

public class LootAcquired {
    private Loot loot;
    private LootReveal lootReveal;

    public LootAcquired(Loot loot) {
        this.loot = loot;
    }

    public LootAcquired(Loot loot, LootReveal lootReveal) {
        this.loot = loot;
        this.lootReveal = lootReveal;
    }

    public Loot getLoot() {
        return this.loot;
    }

    public LootReveal getLootReveal() {
        return this.getLootReveal(null);
    }

    public LootReveal getLootReveal(Player player) {
        boolean bl = this.loot.getLootSettings().dropDuplicate;
        if (!bl) {
            return LootReveal.DISCOVERED;
        }
        if (this.lootReveal != null || player == null) {
            return this.lootReveal;
        }
        PlayerData playerData = PlayerDataManager.getData(player);
        return !playerData.isLootDiscovered(this.loot) ? LootReveal.DISCOVERED : LootReveal.DUPLICATED;
    }
}

