/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.opening.themes.custom;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.events.opening.themes.ThemeExecutor;
import com.xericker.mysteryboxes.core.vaults.VaultData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import utils.LocationUtils;
import utils.PlayerUtils;
import utils.WorldUtils;

public class AstronautTheme
implements ThemeExecutor {
    private OpenEvent openEvent;
    private Location eventLocation;
    private final int VISIBILITY_RADIUS = 50;
    private Map<Block, Material> terrainBlocks;
    private List<Entity> gravityBlockEntities;
    private Map<Entity, Double> blockEntitiesVelocity;

    @Override
    public void startTheme(OpenEvent openEvent) {
        this.openEvent = openEvent;
        this.generateTerrain();
    }

    @Override
    public void stopTheme() {
        for (Block block : this.terrainBlocks.keySet()) {
            block.getState().update();
        }
        for (Entity entity : this.gravityBlockEntities) {
            entity.remove();
        }
        Player player = this.openEvent.getPlayer();
        if (player != null) {
            player.removePotionEffect(PotionEffectType.LEVITATION);
            player.removePotionEffect(PotionEffectType.SLOW_FALLING);
        }
    }

    public void generateTerrain() {
        this.terrainBlocks = new HashMap<Block, Material>();
        this.gravityBlockEntities = new ArrayList<Entity>();
        this.blockEntitiesVelocity = new HashMap<Entity, Double>();
        this.eventLocation = this.openEvent.getEventLocation();
        if (this.openEvent.getOpenData().vault != null) {
            this.eventLocation.setY((double)this.eventLocation.getBlockY());
            this.eventLocation.subtract(0.0, 1.0, 0.0);
        }
        LocationUtils.setSolidBlock(this.eventLocation, BlockFace.DOWN);
        new BukkitRunnable(){
            int terrainStep = 4;
            int terrainRadius = 3;

            public void run() {
                if (AstronautTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                --this.terrainStep;
                if (this.terrainStep == 0) {
                    AstronautTheme.this.disableGravity();
                    this.cancel();
                    return;
                }
                for (Block block : LocationUtils.getCube(AstronautTheme.this.eventLocation, this.terrainRadius)) {
                    if (AstronautTheme.this.terrainBlocks.containsKey(block) || block.isEmpty() || block.getLocation().getY() < AstronautTheme.this.eventLocation.getY() || VaultData.getVault(block.getRelative(BlockFace.UP).getLocation()) != null || VaultData.getVault(block.getLocation()) != null) continue;
                    Material material = this.terrainStep == 1 ? Material.PURPUR_BLOCK : Material.END_STONE_BRICKS;
                    BlockData blockData = Bukkit.createBlockData((Material)material);
                    BlockData blockData2 = block.getBlockData();
                    if (blockData2 instanceof Slab) {
                        Slab slab = (Slab)blockData2;
                        material = this.terrainStep == 1 ? Material.PURPUR_SLAB : Material.END_STONE_BRICK_SLAB;
                        blockData2 = (Slab)Bukkit.createBlockData((Material)material);
                        blockData2.setType(slab.getType());
                        blockData = blockData2;
                    } else {
                        blockData2 = block.getBlockData();
                        if (blockData2 instanceof Stairs) {
                            Stairs stairs = (Stairs)blockData2;
                            material = this.terrainStep == 1 ? Material.PURPUR_STAIRS : Material.END_STONE_BRICK_STAIRS;
                            blockData2 = (Stairs)Bukkit.createBlockData((Material)material);
                            blockData2.setShape(stairs.getShape());
                            blockData2.setFacing(stairs.getFacing());
                            blockData = blockData2;
                        }
                    }
                    WorldUtils.playStepSound(block.getLocation(), blockData.getMaterial(), 1);
                    for (Player player : PlayerUtils.getNearbyPlayers(AstronautTheme.this.eventLocation, 50.0)) {
                        player.sendBlockChange(block.getLocation(), blockData);
                    }
                    AstronautTheme.this.terrainBlocks.put(block, material);
                }
                this.terrainRadius += 2;
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 10L);
    }

    public void disableGravity() {
        this.eventLocation.getWorld().playSound(this.eventLocation, Sound.ENTITY_ZOMBIE_VILLAGER_CONVERTED, 1.0f, 1.0f);
        this.eventLocation.getWorld().playSound(this.eventLocation, Sound.ENTITY_GENERIC_EXPLODE, 0.5f, 0.0f);
        for (Block block : this.terrainBlocks.keySet()) {
            for (int i = 0; i < 1; ++i) {
                Location location = block.getLocation().add(0.5, 1.0, 0.5);
                location.add(Main.getRandom().nextDouble() - 0.5, 0.0, Main.getRandom().nextDouble() - 0.5);
                location.getWorld().spawnParticle(Particle.END_ROD, location, 0, 0.0, 1.0, 0.0, Main.getRandom().nextDouble());
            }
            if (this.terrainBlocks.get(block) != Material.PURPUR_BLOCK || !block.getRelative(BlockFace.UP).isEmpty()) continue;
            Location location = block.getLocation().add(0.5, 1.0, 0.5);
            location.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, location, 1, 0.0, 0.0, 0.0, 1.0);
            this.spawnGravityBlock(block);
        }
        new BukkitRunnable(){
            int potionStep = -1;
            int gravityBlockStep = -1;

            public void run() {
                if (AstronautTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                Player player = AstronautTheme.this.openEvent.getPlayer();
                ++this.potionStep;
                if (this.potionStep == 0) {
                    boolean bl;
                    this.potionStep = -10;
                    boolean bl2 = bl = player.getWorld() == AstronautTheme.this.eventLocation.getWorld() && player.getLocation().distance(AstronautTheme.this.eventLocation) <= 5.0;
                    if (bl) {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 20, 0, true, false, false));
                        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 100, 4, true, false, false));
                    }
                }
                ++this.gravityBlockStep;
                if (this.gravityBlockStep == 0) {
                    this.gravityBlockStep = -10;
                    for (Block entity : AstronautTheme.this.terrainBlocks.keySet()) {
                        if (Main.getRandom().nextInt(100) > 15 || AstronautTheme.this.terrainBlocks.get(entity) != Material.PURPUR_BLOCK || !entity.getRelative(BlockFace.UP).isEmpty()) continue;
                        AstronautTheme.this.spawnGravityBlock(entity);
                        break;
                    }
                }
                for (Entity entity : AstronautTheme.this.gravityBlockEntities) {
                    if (entity.isDead()) continue;
                    Vector vector = new Vector(0.0, AstronautTheme.this.blockEntitiesVelocity.get(entity).doubleValue(), 0.0);
                    entity.setVelocity(vector.multiply(0.05));
                    Location location = entity.getLocation();
                    if (location.getY() - AstronautTheme.this.eventLocation.getY() > 10.0) {
                        entity.remove();
                    }
                    if (location.getBlock().getRelative(BlockFace.UP).isEmpty()) continue;
                    entity.remove();
                }
                for (Block block : AstronautTheme.this.terrainBlocks.keySet()) {
                    if (Main.getRandom().nextInt(100) > 2 || AstronautTheme.this.terrainBlocks.get(block) != Material.PURPUR_BLOCK) continue;
                    block.getWorld().spawnParticle(Particle.END_ROD, block.getLocation().add(0.5, 0.0, 0.5), 0, 0.0, 1.0, 0.0, Main.getRandom().nextDouble());
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 1L);
    }

    public void spawnGravityBlock(Block block) {
        BlockData blockData = Bukkit.createBlockData((Material)this.terrainBlocks.get(block));
        FallingBlock fallingBlock = block.getWorld().spawnFallingBlock(block.getLocation().add(0.5, 1.0, 0.5), blockData);
        fallingBlock.setMetadata(Main.getMetadataValue(), (MetadataValue)Main.getFixedMetadataValue());
        fallingBlock.setGravity(false);
        this.gravityBlockEntities.add((Entity)fallingBlock);
        double d = Main.getRandom().nextDouble();
        if (d < 0.5) {
            d = 0.5 + Main.getRandom().nextDouble();
        }
        this.blockEntitiesVelocity.put((Entity)fallingBlock, d);
    }
}

