/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.opening.themes.custom;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.events.opening.themes.ThemeExecutor;
import com.xericker.mysteryboxes.core.vaults.VaultData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.Bat;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import utils.LocationUtils;
import utils.PlayerUtils;
import utils.PluginUtils;
import utils.WorldUtils;

public class HalloweenTheme
implements ThemeExecutor {
    private OpenEvent openEvent;
    private Location eventLocation;
    private final int VISIBILITY_RADIUS = 50;
    private Map<Block, Material> terrainBlocks;
    private List<LivingEntity> skeletons;
    private Map<LivingEntity, Double> bats;
    private Map<LivingEntity, Integer> circleIndexes;
    private List<Location> circleLocs;
    private final int CIRCLE_RADIUS = 4;
    private final int CIRCLE_POINTS = 50;

    @Override
    public void startTheme(OpenEvent openEvent) {
        this.openEvent = openEvent;
        this.generateTerrain();
    }

    @Override
    public void stopTheme() {
        for (Block block : this.terrainBlocks.keySet()) {
            block.getState().update();
        }
        for (LivingEntity livingEntity : this.skeletons) {
            livingEntity.remove();
        }
        for (LivingEntity livingEntity : this.bats.keySet()) {
            livingEntity.remove();
        }
    }

    public void generateTerrain() {
        this.terrainBlocks = new HashMap<Block, Material>();
        this.bats = new HashMap<LivingEntity, Double>();
        this.skeletons = new ArrayList<LivingEntity>();
        this.eventLocation = this.openEvent.getEventLocation();
        if (this.openEvent.getOpenData().vault != null) {
            this.eventLocation.setY((double)this.eventLocation.getBlockY());
            this.eventLocation.subtract(0.0, 1.0, 0.0);
        }
        LocationUtils.setSolidBlock(this.eventLocation, BlockFace.DOWN);
        this.circleIndexes = new HashMap<LivingEntity, Integer>();
        this.circleLocs = LocationUtils.getCircle(this.eventLocation, 4.0, 50);
        new BukkitRunnable(){
            int terrainStep = 4;
            int terrainRadius = 3;

            public void run() {
                BlockData blockData;
                if (HalloweenTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                --this.terrainStep;
                if (this.terrainStep == 0) {
                    this.cancel();
                    return;
                }
                if (this.terrainStep == 1) {
                    HalloweenTheme.this.spawnSkeletons();
                    HalloweenTheme.this.spawnBats();
                    if (HalloweenTheme.this.openEvent.getOpenData().vault != null) {
                        Location location = HalloweenTheme.this.openEvent.getOpenData().vault.getVaultLoc();
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            blockData = Bukkit.createBlockData((Material)Material.PUMPKIN);
                            player.sendBlockChange(location, blockData);
                        }
                        HalloweenTheme.this.terrainBlocks.put(location.getBlock(), Material.PUMPKIN);
                    }
                }
                for (Block block : LocationUtils.getCube(HalloweenTheme.this.eventLocation, this.terrainRadius)) {
                    Player player;
                    if (HalloweenTheme.this.terrainBlocks.containsKey(block) || block.isEmpty() || block.getLocation().getY() < HalloweenTheme.this.eventLocation.getY() || VaultData.getVault(block.getRelative(BlockFace.UP).getLocation()) != null || VaultData.getVault(block.getLocation()) != null) continue;
                    player = Material.NETHER_BRICKS;
                    blockData = Bukkit.createBlockData((Material)player);
                    BlockData blockData2 = block.getBlockData();
                    if (blockData2 instanceof Slab) {
                        Slab slab = (Slab)blockData2;
                        player = Material.NETHER_BRICK_SLAB;
                        blockData2 = (Slab)Bukkit.createBlockData((Material)player);
                        blockData2.setType(slab.getType());
                        blockData = blockData2;
                    } else {
                        blockData2 = block.getBlockData();
                        if (blockData2 instanceof Stairs) {
                            Stairs stairs = (Stairs)blockData2;
                            player = Material.NETHER_BRICK_STAIRS;
                            blockData2 = (Stairs)Bukkit.createBlockData((Material)player);
                            blockData2.setShape(stairs.getShape());
                            blockData2.setFacing(stairs.getFacing());
                            blockData = blockData2;
                        }
                    }
                    WorldUtils.playStepSound(block.getLocation(), blockData.getMaterial(), 1);
                    for (Player player2 : PlayerUtils.getNearbyPlayers(HalloweenTheme.this.eventLocation, 50.0)) {
                        player2.sendBlockChange(block.getLocation(), blockData);
                    }
                    HalloweenTheme.this.terrainBlocks.put(block, (Material)player);
                }
                this.terrainRadius += 2;
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 10L);
    }

    public void spawnSkeletons() {
        Location[] locationArray;
        for (Location location : locationArray = new Location[]{new Location(this.eventLocation.getWorld(), this.eventLocation.getX() - 3.0, this.eventLocation.getY(), this.eventLocation.getZ() - 3.0), new Location(this.eventLocation.getWorld(), this.eventLocation.getX() + 3.0, this.eventLocation.getY(), this.eventLocation.getZ() + 3.0), new Location(this.eventLocation.getWorld(), this.eventLocation.getX() + 3.0, this.eventLocation.getY(), this.eventLocation.getZ() - 3.0), new Location(this.eventLocation.getWorld(), this.eventLocation.getX() - 3.0, this.eventLocation.getY(), this.eventLocation.getZ() + 3.0)}) {
            LocationUtils.setAirLocation(location, BlockFace.UP);
            location.add(0.0, 0.25, 0.0);
            Vector vector = this.eventLocation.toVector().subtract(location.toVector()).normalize();
            location.setDirection(vector);
            Skeleton skeleton = (Skeleton)this.eventLocation.getWorld().spawn(location, Skeleton.class);
            skeleton.setMetadata(Main.getMetadataValue(), (MetadataValue)Main.getFixedMetadataValue());
            skeleton.getEquipment().setHelmet(new ItemStack(Material.CARVED_PUMPKIN));
            skeleton.setAI(false);
            skeleton.setCollidable(false);
            this.skeletons.add((LivingEntity)skeleton);
            skeleton.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, skeleton.getEyeLocation(), 1, 0.0, 0.0, 0.0, 1.0);
        }
        new BukkitRunnable(){
            int skeletonStep = 0;

            public void run() {
                Vector vector;
                Location location;
                if (HalloweenTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                if (this.skeletonStep == 0) {
                    this.skeletonStep = 5;
                    for (LivingEntity livingEntity : HalloweenTheme.this.skeletons) {
                        Location location2 = livingEntity.getLocation();
                        location2.setYaw((float)PluginUtils.getRandomInt(-180, 180));
                        location2.setPitch((float)PluginUtils.getRandomInt(-90, 90));
                        livingEntity.teleport(location2);
                        location = location2.clone();
                        location.add(Main.getRandom().nextDouble() - 0.5, 0.0, Main.getRandom().nextDouble() - 0.5);
                        vector = new Vector(0.0, 0.15, 0.0);
                        livingEntity.getWorld().spawnParticle(Particle.FLAME, location, 0, vector.getX(), vector.getY(), vector.getZ(), 1.0);
                        livingEntity.getWorld().spawnParticle(Particle.SMOKE_NORMAL, location, 0, vector.getX(), vector.getY(), vector.getZ(), 1.0);
                    }
                }
                --this.skeletonStep;
                for (LivingEntity livingEntity : HalloweenTheme.this.bats.keySet()) {
                    int n = HalloweenTheme.this.circleIndexes.get(livingEntity);
                    HalloweenTheme.this.circleIndexes.put(livingEntity, n + 1);
                    if (HalloweenTheme.this.circleIndexes.get(livingEntity) == 50) {
                        HalloweenTheme.this.circleIndexes.put(livingEntity, 0);
                    }
                    location = HalloweenTheme.this.circleLocs.get(n).clone();
                    location.add(0.0, HalloweenTheme.this.bats.get(livingEntity).doubleValue(), 0.0);
                    vector = HalloweenTheme.this.eventLocation.toVector().subtract(location.toVector()).normalize();
                    location.setDirection(vector);
                    livingEntity.teleport(location);
                    livingEntity.getWorld().spawnParticle(Particle.FLAME, livingEntity.getEyeLocation(), 1, 0.0, 0.0, 0.0, 0.0);
                    livingEntity.getWorld().spawnParticle(Particle.SMOKE_NORMAL, livingEntity.getEyeLocation(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 2L);
    }

    public void spawnBats() {
        new BukkitRunnable(){
            int spawnStep = 1;

            public void run() {
                if (HalloweenTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                --this.spawnStep;
                if (this.spawnStep == 0) {
                    this.spawnStep = 8;
                    Bat bat = (Bat)HalloweenTheme.this.eventLocation.getWorld().spawn(HalloweenTheme.this.eventLocation, Bat.class);
                    bat.setMetadata(Main.getMetadataValue(), (MetadataValue)Main.getFixedMetadataValue());
                    bat.setAI(false);
                    bat.setCollidable(false);
                    HalloweenTheme.this.bats.put((LivingEntity)bat, 0.0);
                    HalloweenTheme.this.circleIndexes.put((LivingEntity)bat, Main.getRandom().nextInt(50));
                }
                for (LivingEntity livingEntity : HalloweenTheme.this.bats.keySet()) {
                    if (HalloweenTheme.this.bats.get(livingEntity) > 7.0) {
                        livingEntity.remove();
                        continue;
                    }
                    int n = HalloweenTheme.this.circleIndexes.get(livingEntity);
                    HalloweenTheme.this.circleIndexes.put(livingEntity, n + 1);
                    if (HalloweenTheme.this.circleIndexes.get(livingEntity) == 50) {
                        HalloweenTheme.this.circleIndexes.put(livingEntity, 0);
                    }
                    HalloweenTheme.this.bats.put(livingEntity, HalloweenTheme.this.bats.get(livingEntity) + 0.15);
                    Location location = HalloweenTheme.this.circleLocs.get(n).clone();
                    location.add(0.0, HalloweenTheme.this.bats.get(livingEntity).doubleValue(), 0.0);
                    livingEntity.teleport(location);
                    livingEntity.getWorld().spawnParticle(Particle.FLAME, livingEntity.getEyeLocation(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 2L);
    }
}

