/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.opening.themes.custom;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.events.opening.themes.ThemeExecutor;
import com.xericker.mysteryboxes.core.vaults.VaultData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import utils.ItemUtils;
import utils.LocationUtils;
import utils.PluginUtils;
import utils.WorldUtils;

public class MiningFrenzyTheme
implements ThemeExecutor {
    private OpenEvent openEvent;
    private Location eventLocation;
    private Map<Block, Material> terrainBlocks;
    private Map<Villager, Integer> miningVillagers;
    private List<Item> droppedItems;

    @Override
    public void startTheme(OpenEvent openEvent) {
        this.openEvent = openEvent;
        this.generateTerrain();
    }

    @Override
    public void stopTheme() {
        for (Block block : this.terrainBlocks.keySet()) {
            block.getState().update();
        }
        for (Villager villager : this.miningVillagers.keySet()) {
            villager.remove();
        }
        for (Entity entity : this.droppedItems) {
            entity.remove();
        }
    }

    public void generateTerrain() {
        this.terrainBlocks = new HashMap<Block, Material>();
        this.miningVillagers = new HashMap<Villager, Integer>();
        this.droppedItems = new ArrayList<Item>();
        this.eventLocation = this.openEvent.getEventLocation();
        if (this.openEvent.getOpenData().vault != null) {
            this.eventLocation.setY((double)this.eventLocation.getBlockY());
            this.eventLocation.subtract(0.0, 1.0, 0.0);
        }
        LocationUtils.setSolidBlock(this.eventLocation, BlockFace.DOWN);
        new BukkitRunnable(){
            int terrainStep = 4;
            int terrainRadius = 3;
            float soundPitch = 0.75f;

            public void run() {
                Location location;
                Location location2;
                if (MiningFrenzyTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                if (this.terrainStep == 2) {
                    Location[] locationArray = new Location[]{new Location(MiningFrenzyTheme.this.eventLocation.getWorld(), MiningFrenzyTheme.this.eventLocation.getX() - 3.0, MiningFrenzyTheme.this.eventLocation.getY(), MiningFrenzyTheme.this.eventLocation.getZ() - 3.0), new Location(MiningFrenzyTheme.this.eventLocation.getWorld(), MiningFrenzyTheme.this.eventLocation.getX() + 3.0, MiningFrenzyTheme.this.eventLocation.getY(), MiningFrenzyTheme.this.eventLocation.getZ() + 3.0), new Location(MiningFrenzyTheme.this.eventLocation.getWorld(), MiningFrenzyTheme.this.eventLocation.getX() + 3.0, MiningFrenzyTheme.this.eventLocation.getY(), MiningFrenzyTheme.this.eventLocation.getZ() - 3.0), new Location(MiningFrenzyTheme.this.eventLocation.getWorld(), MiningFrenzyTheme.this.eventLocation.getX() - 3.0, MiningFrenzyTheme.this.eventLocation.getY(), MiningFrenzyTheme.this.eventLocation.getZ() + 3.0)};
                    for (int i = 0; i < locationArray.length; ++i) {
                        location2 = locationArray[i];
                        LocationUtils.setAirLocation(location2, BlockFace.UP);
                        location2.add(0.0, 1.0, 0.0);
                        location = MiningFrenzyTheme.this.eventLocation.toVector().subtract(location2.toVector()).normalize();
                        location2.setDirection((Vector)location);
                        Villager villager = (Villager)MiningFrenzyTheme.this.eventLocation.getWorld().spawn(location2, Villager.class);
                        villager.setMetadata(Main.getMetadataValue(), (MetadataValue)Main.getFixedMetadataValue());
                        villager.getEquipment().setItemInMainHand(new ItemStack(Material.IRON_PICKAXE));
                        villager.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, Integer.MAX_VALUE, 5, true, false, false));
                        villager.setBaby();
                        MiningFrenzyTheme.this.miningVillagers.put(villager, -7 - Main.getRandom().nextInt(5));
                    }
                }
                --this.terrainStep;
                if (this.terrainStep == 0) {
                    MiningFrenzyTheme.this.spawnVillager();
                    this.cancel();
                    return;
                }
                this.soundPitch = (float)((double)this.soundPitch + 0.25);
                MiningFrenzyTheme.this.eventLocation.getWorld().playSound(MiningFrenzyTheme.this.eventLocation, Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, this.soundPitch);
                MiningFrenzyTheme.this.eventLocation.getWorld().playSound(MiningFrenzyTheme.this.eventLocation, Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 0.25f, this.soundPitch);
                for (Block block : LocationUtils.getCube(MiningFrenzyTheme.this.eventLocation, this.terrainRadius)) {
                    if (MiningFrenzyTheme.this.terrainBlocks.containsKey(block) || block.isEmpty() || !block.getRelative(BlockFace.UP).isEmpty() && MiningFrenzyTheme.this.eventLocation.getY() - (double)block.getY() > 0.5 || VaultData.getVault(block.getRelative(BlockFace.UP).getLocation()) != null || VaultData.getVault(block.getLocation()) != null) continue;
                    location2 = new Location[]{Material.COAL_ORE, Material.IRON_ORE, Material.GOLD_ORE, Material.LAPIS_ORE, Material.REDSTONE_ORE, Material.EMERALD_ORE, Material.DIAMOND_ORE};
                    location = location2[Main.getRandom().nextInt(((Material[])location2).length)];
                    if (!block.getRelative(BlockFace.UP).isEmpty()) {
                        location = Material.COBBLESTONE;
                    }
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        BlockData blockData = Bukkit.createBlockData((Material)location);
                        player.sendBlockChange(block.getLocation(), blockData);
                    }
                    MiningFrenzyTheme.this.terrainBlocks.put(block, (Material)location);
                }
                this.terrainRadius += 2;
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 10L);
    }

    public void spawnVillager() {
        for (Villager villager : this.miningVillagers.keySet()) {
            villager.setAI(true);
        }
        new BukkitRunnable(){
            int mineIndex = 0;
            int jumpStep = -1;
            boolean villagersTeleported = false;
            List<Villager> wealthyVillagers = new ArrayList<Villager>();

            public void run() {
                Color[] colorArray;
                Material material;
                Location location;
                Block block;
                if (MiningFrenzyTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                if (!this.villagersTeleported && this.wealthyVillagers.size() == MiningFrenzyTheme.this.miningVillagers.size()) {
                    this.villagersTeleported = true;
                    Location[] locationArray = new Location[]{new Location(MiningFrenzyTheme.this.eventLocation.getWorld(), MiningFrenzyTheme.this.eventLocation.getX() - 3.0, MiningFrenzyTheme.this.eventLocation.getY(), MiningFrenzyTheme.this.eventLocation.getZ() - 3.0), new Location(MiningFrenzyTheme.this.eventLocation.getWorld(), MiningFrenzyTheme.this.eventLocation.getX() + 3.0, MiningFrenzyTheme.this.eventLocation.getY(), MiningFrenzyTheme.this.eventLocation.getZ() + 3.0), new Location(MiningFrenzyTheme.this.eventLocation.getWorld(), MiningFrenzyTheme.this.eventLocation.getX() + 3.0, MiningFrenzyTheme.this.eventLocation.getY(), MiningFrenzyTheme.this.eventLocation.getZ() - 3.0), new Location(MiningFrenzyTheme.this.eventLocation.getWorld(), MiningFrenzyTheme.this.eventLocation.getX() - 3.0, MiningFrenzyTheme.this.eventLocation.getY(), MiningFrenzyTheme.this.eventLocation.getZ() + 3.0)};
                    for (int i = 0; i < locationArray.length; ++i) {
                        block = locationArray[i];
                        LocationUtils.setAirLocation((Location)block, BlockFace.UP);
                        block.add(0.0, 1.0, 0.0);
                        location = MiningFrenzyTheme.this.eventLocation.toVector().subtract(block.toVector()).normalize();
                        block.setDirection((Vector)location);
                        material = this.wealthyVillagers.get(i);
                        material.teleport((Location)block);
                        colorArray = new Color[]{Color.BLACK, Color.GRAY, Color.YELLOW, Color.LIME, Color.BLUE, Color.AQUA};
                        WorldUtils.spawnFirework(material.getEyeLocation(), FireworkEffect.Type.BURST, true, false, 0, Collections.singletonList(colorArray[Main.getRandom().nextInt(colorArray.length)]), Collections.singletonList(Color.WHITE));
                    }
                }
                ++this.jumpStep;
                if (this.jumpStep == 0) {
                    this.jumpStep = -20;
                    for (Villager villager : this.wealthyVillagers) {
                        villager.setVelocity(new Vector(0.0, 0.35, 0.0));
                    }
                }
                if (this.villagersTeleported) {
                    return;
                }
                for (Villager villager : MiningFrenzyTheme.this.miningVillagers.keySet()) {
                    if (this.wealthyVillagers.contains(villager)) continue;
                    MiningFrenzyTheme.this.miningVillagers.put(villager, MiningFrenzyTheme.this.miningVillagers.get(villager) + 1);
                    if (MiningFrenzyTheme.this.miningVillagers.get(villager) < 0) continue;
                    MiningFrenzyTheme.this.miningVillagers.put(villager, -7 - Main.getRandom().nextInt(5));
                    if (this.mineIndex == MiningFrenzyTheme.this.terrainBlocks.keySet().toArray().length) {
                        this.wealthyVillagers.add(villager);
                        continue;
                    }
                    block = (Block)MiningFrenzyTheme.this.terrainBlocks.keySet().toArray()[this.mineIndex];
                    location = block.getLocation().add(0.5, 1.0, 0.5);
                    location.setYaw((float)PluginUtils.getRandomInt(-180, 180));
                    villager.teleport(location);
                    if (Main.getRandom().nextInt(100) <= 50) {
                        material = MiningFrenzyTheme.this.terrainBlocks.get(block);
                        colorArray = Material.COAL;
                        if (material == Material.IRON_ORE) {
                            colorArray = Material.IRON_INGOT;
                        } else if (material == Material.GOLD_INGOT) {
                            colorArray = Material.GOLD_INGOT;
                        } else if (material == Material.LAPIS_LAZULI) {
                            colorArray = Material.LAPIS_LAZULI;
                        } else if (material == Material.REDSTONE_ORE) {
                            colorArray = Material.REDSTONE;
                        } else if (material == Material.EMERALD_ORE) {
                            colorArray = Material.EMERALD;
                        } else if (material == Material.DIAMOND_ORE) {
                            colorArray = Material.DIAMOND;
                        }
                        Item item = ItemUtils.dropItem((Plugin)Main.getPlugin(), villager.getEyeLocation(), new ItemStack((Material)colorArray), 40);
                        item.setMetadata(Main.getMetadataValue(), (MetadataValue)Main.getFixedMetadataValue());
                        item.setVelocity(new Vector(0.0, Main.getRandom().nextDouble() / 1.5, 0.0));
                        MiningFrenzyTheme.this.droppedItems.add(item);
                    }
                    WorldUtils.playStepSound(block.getLocation(), MiningFrenzyTheme.this.terrainBlocks.get(block), 1);
                    block.getState().update();
                    ++this.mineIndex;
                    if (this.mineIndex != MiningFrenzyTheme.this.terrainBlocks.keySet().toArray().length) continue;
                    this.wealthyVillagers.add(villager);
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 1L);
    }
}

