/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.opening.themes.custom;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.events.opening.themes.ThemeExecutor;
import com.xericker.mysteryboxes.core.vaults.VaultData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import utils.LocationUtils;
import utils.PlayerUtils;
import utils.WorldUtils;

public class SummerBreezeTheme
implements ThemeExecutor {
    private OpenEvent openEvent;
    private Location eventLocation;
    private final int VISIBILITY_RADIUS = 50;
    private Map<Block, Material> terrainBlocks;
    private List<LivingEntity> dolphins;
    private Map<LivingEntity, Integer> circleIndexes;
    private List<Location> circleLocs;

    @Override
    public void startTheme(OpenEvent openEvent) {
        this.openEvent = openEvent;
        this.generateTerrain();
    }

    @Override
    public void stopTheme() {
        for (Block block : this.terrainBlocks.keySet()) {
            block.getState().update();
        }
        for (Entity entity : this.dolphins) {
            entity.remove();
        }
    }

    public void generateTerrain() {
        this.terrainBlocks = new HashMap<Block, Material>();
        this.dolphins = new ArrayList<LivingEntity>();
        this.eventLocation = this.openEvent.getEventLocation();
        if (this.openEvent.getOpenData().vault != null) {
            this.eventLocation.setY((double)this.eventLocation.getBlockY());
            this.eventLocation.subtract(0.0, 1.0, 0.0);
        }
        LocationUtils.setSolidBlock(this.eventLocation, BlockFace.DOWN);
        new BukkitRunnable(){
            int terrainStep = 4;
            int terrainRadius = 3;

            public void run() {
                if (SummerBreezeTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                --this.terrainStep;
                if (this.terrainStep == 0) {
                    this.cancel();
                    return;
                }
                for (Block block : LocationUtils.getCube(SummerBreezeTheme.this.eventLocation, this.terrainRadius)) {
                    if (SummerBreezeTheme.this.terrainBlocks.containsKey(block) || block.isEmpty() || block.getLocation().getY() < SummerBreezeTheme.this.eventLocation.getY() || VaultData.getVault(block.getRelative(BlockFace.UP).getLocation()) != null || VaultData.getVault(block.getLocation()) != null) continue;
                    Material material = Material.SAND;
                    BlockData blockData = Bukkit.createBlockData((Material)material);
                    BlockData blockData2 = block.getBlockData();
                    if (blockData2 instanceof Slab) {
                        Slab slab = (Slab)blockData2;
                        material = Material.SANDSTONE_SLAB;
                        blockData2 = (Slab)Bukkit.createBlockData((Material)material);
                        blockData2.setType(slab.getType());
                        blockData = blockData2;
                    } else {
                        blockData2 = block.getBlockData();
                        if (blockData2 instanceof Stairs) {
                            Stairs stairs = (Stairs)blockData2;
                            material = Material.SANDSTONE_STAIRS;
                            blockData2 = (Stairs)Bukkit.createBlockData((Material)material);
                            blockData2.setShape(stairs.getShape());
                            blockData2.setFacing(stairs.getFacing());
                            blockData = blockData2;
                        }
                    }
                    WorldUtils.playStepSound(block.getLocation(), blockData.getMaterial(), 1);
                    for (Player player : PlayerUtils.getNearbyPlayers(SummerBreezeTheme.this.eventLocation, 50.0)) {
                        player.sendBlockChange(block.getLocation(), blockData);
                    }
                    SummerBreezeTheme.this.terrainBlocks.put(block, material);
                }
                this.terrainRadius += 2;
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 10L);
    }
}

