/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.opening.themes.custom;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.compiled.Laser;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.events.opening.themes.ThemeExecutor;
import com.xericker.mysteryboxes.core.vaults.VaultData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import utils.LocationUtils;

public class UnderwaterTroubleTheme
implements ThemeExecutor {
    private OpenEvent openEvent;
    private Location eventLocation;
    private Map<Block, Material> terrainBlocks;
    private List<LivingEntity> guardians;
    private Map<Laser.GuardianLaser, LivingEntity> lasers;
    private Map<LivingEntity, Integer> circleIndexes;
    private List<Location> circleLocs;

    @Override
    public void startTheme(OpenEvent openEvent) {
        this.openEvent = openEvent;
        this.generateTerrain();
    }

    @Override
    public void stopTheme() {
        for (Block object : this.terrainBlocks.keySet()) {
            object.getState().update();
        }
        for (LivingEntity livingEntity : this.guardians) {
            livingEntity.remove();
        }
        for (Laser.GuardianLaser guardianLaser : this.lasers.keySet()) {
            if (!guardianLaser.isStarted()) continue;
            guardianLaser.stop();
        }
    }

    public void generateTerrain() {
        this.terrainBlocks = new HashMap<Block, Material>();
        this.guardians = new ArrayList<LivingEntity>();
        this.lasers = new HashMap<Laser.GuardianLaser, LivingEntity>();
        this.circleIndexes = new HashMap<LivingEntity, Integer>();
        this.eventLocation = this.openEvent.getEventLocation();
        if (this.openEvent.getOpenData().vault != null) {
            this.eventLocation.setY((double)this.eventLocation.getBlockY());
            this.eventLocation.subtract(0.0, 1.0, 0.0);
        }
        LocationUtils.setSolidBlock(this.eventLocation, BlockFace.DOWN);
        this.circleLocs = LocationUtils.getCircle(this.eventLocation, 4.5, 50);
        new BukkitRunnable(){
            int terrainStep = 4;
            int terrainRadius = 3;
            float soundPitch = 0.75f;

            public void run() {
                Object object;
                Material material;
                if (UnderwaterTroubleTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                --this.terrainStep;
                if (this.terrainStep == 0) {
                    this.cancel();
                    return;
                }
                if (this.terrainStep == 1) {
                    UnderwaterTroubleTheme.this.spawnGuardians();
                    UnderwaterTroubleTheme.this.eventLocation.getWorld().playSound(UnderwaterTroubleTheme.this.eventLocation, Sound.ENTITY_PLAYER_SPLASH_HIGH_SPEED, 1.0f, 0.0f);
                    UnderwaterTroubleTheme.this.eventLocation.getWorld().playSound(UnderwaterTroubleTheme.this.eventLocation, Sound.ENTITY_ZOMBIE_CONVERTED_TO_DROWNED, 1.0f, 0.0f);
                    if (UnderwaterTroubleTheme.this.openEvent.getOpenData().vault != null) {
                        material = UnderwaterTroubleTheme.this.openEvent.getOpenData().vault.getVaultLoc();
                        object = Bukkit.createBlockData((Material)Material.WET_SPONGE);
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            player.sendBlockChange((Location)material, (BlockData)object);
                        }
                        UnderwaterTroubleTheme.this.terrainBlocks.put(material.getBlock(), Material.WET_SPONGE);
                    }
                    material = UnderwaterTroubleTheme.this.eventLocation.clone().add(0.0, 2.0, 0.0);
                    for (Location location : LocationUtils.getSphere((Location)material, 6, true)) {
                        if (!location.getBlock().isEmpty()) continue;
                        BlockData blockData = Bukkit.createBlockData((Material)Material.WATER);
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            player.sendBlockChange(location, blockData);
                        }
                        UnderwaterTroubleTheme.this.terrainBlocks.put(location.getBlock(), Material.WATER);
                    }
                }
                this.soundPitch = (float)((double)this.soundPitch + 0.25);
                UnderwaterTroubleTheme.this.eventLocation.getWorld().playSound(UnderwaterTroubleTheme.this.eventLocation, Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, this.soundPitch);
                UnderwaterTroubleTheme.this.eventLocation.getWorld().playSound(UnderwaterTroubleTheme.this.eventLocation, Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 0.25f, this.soundPitch);
                material = Material.PRISMARINE_BRICKS;
                if (this.terrainStep == 1) {
                    material = Material.DARK_PRISMARINE;
                }
                object = Bukkit.createBlockData((Material)material);
                for (Block block : LocationUtils.getCube(UnderwaterTroubleTheme.this.eventLocation, this.terrainRadius)) {
                    if (UnderwaterTroubleTheme.this.terrainBlocks.containsKey(block) || block.isEmpty() || VaultData.getVault(block.getRelative(BlockFace.UP).getLocation()) != null || VaultData.getVault(block.getLocation()) != null) continue;
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        player.sendBlockChange(block.getLocation(), (BlockData)object);
                    }
                    UnderwaterTroubleTheme.this.terrainBlocks.put(block, material);
                }
                this.terrainRadius += 2;
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 10L);
    }

    public void spawnGuardians() {
        new BukkitRunnable(){
            boolean spawnGuardians = true;

            /*
             * WARNING - void declaration
             */
            public void run() {
                Laser.GuardianLaser guardianLaser;
                Location location;
                if (UnderwaterTroubleTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                try {
                    if (this.spawnGuardians && UnderwaterTroubleTheme.this.openEvent.getBigBoxEntity() != null) {
                        void object;
                        int n = 0;
                        boolean i = false;
                        while (object < 4) {
                            if ((n += UnderwaterTroubleTheme.this.circleLocs.size() / 4) == UnderwaterTroubleTheme.this.circleLocs.size()) {
                                --n;
                            }
                            LivingEntity livingEntity = UnderwaterTroubleTheme.this.circleLocs.get(n).clone();
                            livingEntity.setY(UnderwaterTroubleTheme.this.openEvent.getBigBoxEntity().getEyeLocation().getY());
                            location = (Guardian)UnderwaterTroubleTheme.this.eventLocation.getWorld().spawn((Location)livingEntity, Guardian.class);
                            location.setMetadata(Main.getMetadataValue(), (MetadataValue)Main.getFixedMetadataValue());
                            location.setAI(false);
                            location.setCollidable(false);
                            location.setSilent(true);
                            UnderwaterTroubleTheme.this.guardians.add((LivingEntity)location);
                            UnderwaterTroubleTheme.this.circleIndexes.put((LivingEntity)location, n);
                            location.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, location.getEyeLocation(), 1, 0.0, 0.0, 0.0, 1.0);
                            ++object;
                        }
                        for (LivingEntity livingEntity : UnderwaterTroubleTheme.this.guardians) {
                            location = UnderwaterTroubleTheme.this.openEvent.getBigBoxEntity().getEyeLocation();
                            guardianLaser = new Laser.GuardianLaser(livingEntity.getEyeLocation(), location, -1, 50);
                            guardianLaser.start((Plugin)Main.getPlugin());
                            UnderwaterTroubleTheme.this.lasers.put(guardianLaser, livingEntity);
                        }
                        this.spawnGuardians = false;
                    }
                    if (UnderwaterTroubleTheme.this.lasers.size() > 0 && (UnderwaterTroubleTheme.this.openEvent.getBigBoxEntity() == null || UnderwaterTroubleTheme.this.openEvent.getBigBoxEntity().isDead())) {
                        for (Laser.GuardianLaser guardianLaser2 : UnderwaterTroubleTheme.this.lasers.keySet()) {
                            guardianLaser2.stop();
                        }
                        UnderwaterTroubleTheme.this.lasers.clear();
                    }
                    if (UnderwaterTroubleTheme.this.lasers.size() > 0 && UnderwaterTroubleTheme.this.openEvent.getBigBoxEntity() != null && !UnderwaterTroubleTheme.this.openEvent.getBigBoxEntity().isDead()) {
                        for (Laser.GuardianLaser guardianLaser3 : UnderwaterTroubleTheme.this.lasers.keySet()) {
                            guardianLaser3.moveStart(UnderwaterTroubleTheme.this.lasers.get(guardianLaser3).getEyeLocation());
                            guardianLaser3.moveEnd(UnderwaterTroubleTheme.this.openEvent.getBigBoxEntity().getEyeLocation());
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                for (LivingEntity livingEntity : UnderwaterTroubleTheme.this.guardians) {
                    int n = UnderwaterTroubleTheme.this.circleIndexes.get(livingEntity);
                    UnderwaterTroubleTheme.this.circleIndexes.put(livingEntity, n + 1);
                    if (UnderwaterTroubleTheme.this.circleIndexes.get(livingEntity) == 50) {
                        UnderwaterTroubleTheme.this.circleIndexes.put(livingEntity, 0);
                    }
                    location = UnderwaterTroubleTheme.this.circleLocs.get(n).clone();
                    location.setY(UnderwaterTroubleTheme.this.openEvent.getBigBoxEntity().getEyeLocation().getY());
                    guardianLaser = UnderwaterTroubleTheme.this.eventLocation.toVector().subtract(location.toVector()).normalize();
                    location.setDirection((Vector)guardianLaser);
                    livingEntity.teleport(location);
                    livingEntity.getWorld().spawnParticle(Particle.GLOW, livingEntity.getEyeLocation(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 2L);
    }
}

