/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.opening.utils;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.core.effects.EffectStatus;
import com.xericker.mysteryboxes.core.effects.executors.ConfettiEffect;
import com.xericker.mysteryboxes.core.effects.executors.FireworkShowEffect;
import com.xericker.mysteryboxes.core.effects.executors.SpiralPopperEffect;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.events.opening.loots.LootAcquired;
import com.xericker.mysteryboxes.handlers.data.loots.Loot;
import com.xericker.mysteryboxes.handlers.data.loots.LootReveal;
import data.FireworkData;
import data.SoundData;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import utils.WorldUtils;

public class OpenEffects {
    public static void playEffects(Player player, OpenEvent openEvent, Loot loot, ArmorStand armorStand) {
        LootReveal lootReveal = new LootAcquired(loot).getLootReveal(player);
        ConfettiEffect confettiEffect = loot.getEffectsSettings((LootReveal)lootReveal).confettiEffect;
        if (confettiEffect.enabled && confettiEffect.getStatus() == EffectStatus.VALID) {
            confettiEffect.playEffect(armorStand.getEyeLocation());
        }
        FireworkShowEffect fireworkShowEffect = loot.getEffectsSettings((LootReveal)lootReveal).fireworkShow;
        if (fireworkShowEffect.enabled && fireworkShowEffect.getStatus() == EffectStatus.VALID) {
            fireworkShowEffect.playEffect(openEvent, armorStand.getEyeLocation());
        }
        SpiralPopperEffect spiralPopperEffect = loot.getEffectsSettings((LootReveal)lootReveal).spiralPopper;
        if (spiralPopperEffect.enabled && spiralPopperEffect.getStatus() == EffectStatus.VALID) {
            spiralPopperEffect.playEffect(armorStand.getEyeLocation());
        }
    }

    public static void playCharge(ArmorStand armorStand) {
        OpenEffects.playCharge(armorStand.getEyeLocation().add(0.0, 1.0, 0.0));
    }

    public static void playCharge(final Location location) {
        for (int i = 0; i < 250; ++i) {
            Location location2 = location.clone();
            location2.add(Main.getRandom().nextDouble() - 0.5, Main.getRandom().nextDouble() - 0.5, Main.getRandom().nextDouble() - 0.5);
            Vector vector = location2.toVector().subtract(location.toVector()).normalize();
            Vector vector2 = vector.multiply(1.5 + Main.getRandom().nextDouble() * 5.0);
            location.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, location, 0, vector2.getX(), vector2.getY(), vector2.getZ(), 1.0);
        }
        new BukkitRunnable(){
            float pitch = 0.75f;

            public void run() {
                location.getWorld().playSound(location, Sound.ENTITY_FIREWORK_ROCKET_TWINKLE_FAR, 1.0f, this.pitch);
                this.pitch += 0.05f;
                if ((double)this.pitch >= 1.1) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 3L);
    }

    public static void playSounds(Player player, ArmorStand armorStand, Loot loot) {
        LootReveal lootReveal = new LootAcquired(loot).getLootReveal(player);
        Loot.SoundsSettings soundsSettings = loot.getSoundsSettings(lootReveal);
        for (SoundData soundData : soundsSettings.sounds) {
            armorStand.getWorld().playSound(armorStand.getEyeLocation(), soundData.getSound(), soundData.getVolume(), soundData.getPitch());
        }
    }

    public static void spawnFireworks(Player player, ArmorStand armorStand, Loot loot) {
        LootReveal lootReveal = new LootAcquired(loot).getLootReveal(player);
        for (FireworkData fireworkData : loot.getFireworksSettings((LootReveal)lootReveal).fireworks) {
            WorldUtils.spawnFirework(armorStand.getEyeLocation(), fireworkData.getType(), fireworkData.isFlicker(), fireworkData.isTrail(), fireworkData.getPower(), fireworkData.getColors(), fireworkData.getFadeColors());
        }
    }
}

