/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.songpack;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.songpack.SongPackRequest;
import com.xericker.mysteryboxes.handlers.data.songs.SongData;
import com.xericker.mysteryboxes.handlers.data.songs.SongManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.ArrayList;
import java.util.List;
import libraries.colors.ColorScrollPlus;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import utils.MessageUtils;
import utils.PlayerUtils;

public class SongPlayer {
    private OpenEvent openEvent;
    private SongData songData;
    private Player player;
    private int duration;
    private BukkitTask songTask;
    private List<Player> listeners;

    public SongPlayer(Player player, SongData songData, int n) {
        this.player = player;
        this.songData = songData;
        this.duration = n;
    }

    public SongPlayer(OpenEvent openEvent) {
        this.openEvent = openEvent;
    }

    public void playSong() {
        this.listeners = new ArrayList<Player>();
        this.duration *= 2;
        if (this.player == null) {
            this.player = this.openEvent.getPlayer();
        }
        final Location location = this.player.getLocation();
        PlayerData playerData = PlayerDataManager.getData(this.player);
        if (this.songData == null) {
            this.songData = SongManager.getData(playerData.getChosenSongId());
        }
        if (this.openEvent != null && this.openEvent.getOpenData().forceSongData != null) {
            this.songData = this.openEvent.getOpenData().forceSongData;
        }
        if (this.songData == null) {
            return;
        }
        final ColorScrollPlus colorScrollPlus = new ColorScrollPlus(ChatColor.AQUA, this.songData.getGeneralSettings().name, "\u00a7e", "\u00a76", "\u00a76", false, false, ColorScrollPlus.ScrollType.FORWARD);
        this.songTask = new BukkitRunnable(){

            public void run() {
                SongPackRequest songPackRequest;
                PlayerData playerData;
                if (SongPlayer.this.openEvent != null && SongPlayer.this.openEvent.isEventCancelled()) {
                    SongPlayer.this.songTask.cancel();
                    SongPlayer.this.stopSong();
                    return;
                }
                --SongPlayer.this.duration;
                if (SongPlayer.this.duration == 0) {
                    SongPlayer.this.songTask.cancel();
                    SongPlayer.this.stopSong();
                    return;
                }
                for (Player player : PlayerUtils.getNearbyPlayers(location, 15.0)) {
                    boolean bl;
                    if (SongPlayer.this.openEvent == null && player != SongPlayer.this.player || SongPlayer.this.listeners.contains(player)) continue;
                    playerData = PlayerDataManager.getData(player);
                    songPackRequest = playerData.getSongPackRequest();
                    boolean bl2 = bl = songPackRequest != null && songPackRequest.getStatus() == PlayerResourcePackStatusEvent.Status.SUCCESSFULLY_LOADED;
                    if (!bl) continue;
                    player.playSound(player.getLocation(), SongPlayer.this.songData.getSongId(), 0.25f, 1.0f);
                    SongPlayer.this.listeners.add(player);
                }
                String string = colorScrollPlus.next();
                for (int i = 0; i < SongPlayer.this.listeners.size(); ++i) {
                    playerData = SongPlayer.this.listeners.get(i);
                    if (!playerData.isOnline()) {
                        SongPlayer.this.listeners.remove(playerData);
                        continue;
                    }
                    MessageUtils.sendBar((Player)playerData, "\u00a7eNow Playing \u00a77- " + (String)string);
                    playerData.getWorld().spawnParticle(Particle.NOTE, playerData.getEyeLocation().add(0.0, 0.25, 0.0), 1, 0.2, 0.2, 0.2, 1.0);
                    songPackRequest = playerData.getLocation();
                    if (songPackRequest.getWorld() != location.getWorld() || songPackRequest.distance(location) <= 15.0) continue;
                    playerData.stopSound(SongPlayer.this.songData.getSongId());
                    SongPlayer.this.listeners.remove(playerData);
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 10L);
    }

    public void stopSong() {
        if (this.songTask == null) {
            return;
        }
        this.songTask.cancel();
        for (Player player : this.listeners) {
            player.stopSound(this.songData.getSongId());
        }
    }
}

