/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.vaults;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.config.files.VaultsValue;
import com.xericker.mysteryboxes.config.handlers.ConfigFile;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.vaults.VaultAction;
import com.xericker.mysteryboxes.core.vaults.VaultData;
import com.xericker.mysteryboxes.core.vaults.holograms.Hologram;
import com.xericker.mysteryboxes.menus.Menu;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import data.SoundData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import misc.EffectsParser;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Vault {
    private UUID vaultId;
    private Location vaultLoc;
    private List<Hologram> holograms;
    private VaultAction vaultAction;

    public Vault(String string, Location location) {
        this.vaultId = UUID.fromString(string);
        this.vaultLoc = location;
        this.holograms = new ArrayList<Hologram>();
    }

    public UUID getVaultId() {
        return this.vaultId;
    }

    public Location getVaultLoc() {
        return this.vaultLoc.clone();
    }

    public List<Hologram> getHolograms() {
        return this.holograms;
    }

    public VaultAction getVaultAction() {
        return this.vaultAction;
    }

    public void setVaultAction(VaultAction vaultAction) {
        this.vaultAction = vaultAction;
    }

    public static boolean interact(Player player, Location location) {
        try {
            String string2;
            if (VaultData.getVault(location) == null) {
                return false;
            }
            ArrayList<GameMode> arrayList = new ArrayList<GameMode>();
            for (String string2 : ConfigParser.getStringList(VaultsValue.VAULT_ALLOWED_MODES)) {
                for (GameMode gameMode : GameMode.values()) {
                    if (!gameMode.name().equalsIgnoreCase(string2)) continue;
                    arrayList.add(gameMode);
                }
            }
            if (arrayList.isEmpty()) {
                arrayList.addAll(Arrays.asList(GameMode.values()));
            }
            if (!arrayList.contains(player.getGameMode())) {
                return true;
            }
            Object object = ConfigParser.getString(VaultsValue.VAULT_OPEN_PERMISSION);
            if (object == null) {
                object = "mysteryboxes.mystery-vault.open";
            }
            if (!player.hasPermission((String)object)) {
                return true;
            }
            string2 = ConfigParser.getString(VaultsValue.VAULT_MENU_TO_OPEN);
            Menu menu = string2 != null ? Menu.valueOf(string2.toUpperCase()) : Menu.VAULT;
            PlayerData playerData = PlayerDataManager.getData(player);
            Vault vault = VaultData.getVault(location);
            playerData.getOpeningData().setChosenVault(vault);
            menu.open(player);
            for (String string3 : ConfigParser.getStringList(VaultsValue.VAULT_OPEN_SOUNDS)) {
                SoundData soundData = EffectsParser.parseSound(string3);
                player.playSound(player.getLocation(), soundData.getSound(), soundData.getVolume(), soundData.getPitch());
            }
            return true;
        }
        catch (Exception exception) {
            Main.getPlugin().getLogger().warning("[VAULT] Failed to open a Mystery Vault due to invalid Menu ID.");
            return false;
        }
    }

    public static void writeVault(Location location) {
        FileConfiguration fileConfiguration = ConfigFile.VAULT_DATA.getFile();
        if (fileConfiguration == null) {
            return;
        }
        String string = Vault.locationToString(location);
        fileConfiguration.set(string + ".id", (Object)UUID.randomUUID().toString());
    }

    public static void eraseVault(Location location) {
        FileConfiguration fileConfiguration = ConfigFile.VAULT_DATA.getFile();
        if (fileConfiguration == null) {
            return;
        }
        String string = Vault.locationToString(location);
        fileConfiguration.set(string, null);
    }

    public static Location readLocation(String string) {
        String[] stringArray = string.split(";");
        if (Bukkit.getWorld((String)stringArray[0]) == null) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)stringArray[0]), (double)Integer.parseInt(stringArray[1]), (double)Integer.parseInt(stringArray[2]), (double)Integer.parseInt(stringArray[3]));
    }

    public static String locationToString(Location location) {
        return location.getWorld().getName() + ";" + location.getBlockX() + ";" + location.getBlockY() + ";" + location.getBlockZ();
    }
}

