/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.vaults;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.config.files.VaultsValue;
import com.xericker.mysteryboxes.config.handlers.ConfigFile;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.vaults.Vault;
import com.xericker.mysteryboxes.core.vaults.VaultData;
import com.xericker.mysteryboxes.core.vaults.holograms.Hologram;
import com.xericker.mysteryboxes.core.vaults.holograms.HologramData;
import com.xericker.mysteryboxes.core.vaults.holograms.animations.HologramAnimation;
import java.util.Iterator;
import java.util.UUID;
import libraries.EntityHider;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class VaultTask
extends BukkitRunnable {
    private FileConfiguration configFile;
    private boolean spawnHolograms = ConfigParser.getBoolean(VaultsValue.HOLOGRAM_ENABLED);
    private int renderDistance = ConfigParser.getInt(VaultsValue.HOLOGRAM_RENDER_DISTANCE);
    private EntityHider entityHider = new EntityHider();

    public VaultTask() {
        int n = ConfigParser.getInt(VaultsValue.HOLOGRAM_REFRESH_RATE);
        if (n <= 0) {
            n = 1;
        }
        this.runTaskTimer((Plugin)Main.getPlugin(), 0L, n);
    }

    public void run() {
        this.configFile = ConfigFile.VAULT_DATA.getFile();
        if (this.configFile == null) {
            this.cancel();
            return;
        }
        this.removeVaults();
        this.createVaults();
        if (!this.spawnHolograms) {
            return;
        }
        this.spawnHolograms();
        this.clearHolograms();
        this.updateHologramVisibility();
        this.advanceHologramAnimation();
    }

    private void createVaults() {
        this.configFile.getKeys(false).forEach(string -> {
            Location location = Vault.readLocation(string);
            if (location == null || VaultData.getVault(location) != null) {
                return;
            }
            String string2 = this.configFile.getString(string + ".id", UUID.randomUUID().toString());
            this.configFile.set(string + ".id", (Object)string2);
            ConfigFile.VAULT_DATA.saveFile();
            VaultData.getList().add(new Vault(string2, location));
        });
    }

    private void removeVaults() {
        Iterator<Vault> iterator = VaultData.getList().iterator();
        while (iterator.hasNext()) {
            Vault vault = iterator.next();
            String string = Vault.locationToString(vault.getVaultLoc());
            if (this.configFile.contains(string) && this.configFile.getString(string) != null) continue;
            HologramData.unregister(vault);
            iterator.remove();
        }
    }

    private boolean isWithinVaultRange(Player player, Vault vault, double d) {
        if (vault == null) {
            return false;
        }
        boolean bl = vault.getVaultLoc().getWorld() == player.getWorld();
        boolean bl2 = bl && vault.getVaultLoc().distance(player.getLocation()) <= d;
        return bl && bl2;
    }

    private void spawnHolograms() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (Vault vault : VaultData.getList()) {
                Object object;
                boolean bl = this.isWithinVaultRange(player, vault, this.renderDistance);
                boolean bl2 = vault.getHolograms().stream().anyMatch(hologram -> hologram.getPlayerId().equals(player.getUniqueId()));
                if (!bl2 && bl) {
                    object = new Hologram(vault, player.getUniqueId());
                    ((Hologram)object).register();
                    ((Hologram)object).update();
                    HologramData.getList().add((Hologram)object);
                    vault.getHolograms().add((Hologram)object);
                }
                if (!bl2 || bl) continue;
                object = HologramData.getList().iterator();
                while (object.hasNext()) {
                    Hologram hologram2 = (Hologram)object.next();
                    if (!hologram2.getPlayerId().equals(player.getUniqueId()) || !hologram2.getVault().getVaultId().equals(vault.getVaultId())) continue;
                    object.remove();
                    HologramData.unregister(hologram2);
                }
            }
        }
    }

    private void clearHolograms() {
        Iterator<Hologram> iterator = HologramData.getList().iterator();
        while (iterator.hasNext()) {
            Hologram hologram = iterator.next();
            Player player = Bukkit.getPlayer((UUID)hologram.getPlayerId());
            if (hologram.isRemoved() || player != null) continue;
            iterator.remove();
            HologramData.unregister(hologram);
        }
    }

    private void updateHologramVisibility() {
        for (Hologram hologram : HologramData.getList()) {
            hologram.update();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.getUniqueId().equals(hologram.getPlayerId())) continue;
                for (ArmorStand armorStand : hologram.getLines()) {
                    this.entityHider.hideEntity(player, (Entity)armorStand);
                }
            }
        }
    }

    private void advanceHologramAnimation() {
        for (Vault vault : VaultData.getList()) {
            for (Hologram hologram : vault.getHolograms()) {
                for (HologramAnimation hologramAnimation : hologram.getAnimations()) {
                    hologramAnimation.next();
                }
            }
        }
    }
}

