/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.vaults.holograms;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.config.files.VaultsValue;
import com.xericker.mysteryboxes.config.handlers.ConfigFile;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.vaults.Vault;
import com.xericker.mysteryboxes.core.vaults.holograms.animations.HologramAnimation;
import com.xericker.mysteryboxes.handlers.placeholders.GeneralPlaceholders;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Hologram {
    private Vault vault;
    private UUID playerId;
    private boolean removed;
    private List<ArmorStand> lines;
    private List<HologramAnimation> animations;

    public Hologram(Vault vault, UUID uUID) {
        this.vault = vault;
        this.playerId = uUID;
        this.lines = new ArrayList<ArmorStand>();
        this.animations = new ArrayList<HologramAnimation>();
    }

    public void register() {
        FileConfiguration fileConfiguration = ConfigFile.VAULTS.getFile();
        if (fileConfiguration == null) {
            return;
        }
        String string = "animation-builder";
        ConfigurationSection configurationSection = fileConfiguration.getConfigurationSection(string);
        if (configurationSection == null) {
            return;
        }
        for (String string2 : configurationSection.getKeys(false)) {
            HologramAnimation hologramAnimation = new HologramAnimation(string2, string + "." + string2, fileConfiguration);
            hologramAnimation.register();
            this.animations.add(hologramAnimation);
        }
    }

    public void update() {
        Player player;
        Player player2 = player = this.playerId != null ? Bukkit.getPlayer((UUID)this.playerId) : null;
        if (this.removed || player == null) {
            return;
        }
        List<String> list = this.parseLines(player);
        if (this.vault.getVaultAction() != null) {
            list.clear();
        }
        this.validateLines(list);
        if (!this.lines.isEmpty()) {
            this.writeLinesIfNotEmpty(list);
        } else {
            this.writeLinesIfEmpty(list);
        }
    }

    private void validateLines(List<String> list) {
        if (list.size() > this.lines.size() || list.size() < this.lines.size()) {
            for (ArmorStand armorStand : this.lines) {
                armorStand.remove();
            }
            this.lines.clear();
        }
    }

    private List<String> parseLines(Player player) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (String string : ConfigParser.getStringList(VaultsValue.HOLOGRAM_LINES)) {
            for (HologramAnimation hologramAnimation : this.animations) {
                if (hologramAnimation.getDisplay() == null) break block0;
                String string2 = "{ANIMATION_[" + hologramAnimation.getId() + "]}";
                if (!string.contains(string2)) continue;
                if (!hologramAnimation.validateData(player)) continue block0;
                string = string.replace(string2, hologramAnimation.getDisplay());
            }
            arrayList.add(GeneralPlaceholders.translate((Object)player, string));
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private void writeLinesIfNotEmpty(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            ArmorStand armorStand = this.lines.get(i);
            String string = list.get(i);
            armorStand.setCustomName(string);
            armorStand.setCustomNameVisible(!string.isEmpty());
        }
    }

    private void writeLinesIfEmpty(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            Location location = this.vault.getVaultLoc().getBlock().getLocation().add(0.5, -1.5 + 0.3 * (double)(i + 1), 0.5);
            ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
            String string = list.get(i);
            armorStand.setCustomName(string);
            armorStand.setVisible(false);
            armorStand.setGravity(false);
            NamespacedKey namespacedKey = new NamespacedKey((Plugin)Main.getPlugin(), "mysteryvault");
            armorStand.getPersistentDataContainer().set(namespacedKey, PersistentDataType.STRING, (Object)this.vault.getVaultId().toString());
            this.lines.add(armorStand);
        }
    }

    public Vault getVault() {
        return this.vault;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public List<ArmorStand> getLines() {
        return this.lines;
    }

    public List<HologramAnimation> getAnimations() {
        return this.animations;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void remove() {
        for (ArmorStand armorStand : this.lines) {
            armorStand.remove();
        }
        this.removed = true;
    }
}

