/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.alerts;

import com.xericker.mysteryboxes.config.handlers.ConfigFile;
import org.bukkit.configuration.file.FileConfiguration;

public enum AlertType {
    UPDATE("Sent when there's a new version available."),
    WELCOME("Sent upon installing the plugin for the first time.");

    private final String description;

    private AlertType(String string2) {
        this.description = string2;
    }

    public String getId() {
        return this.name().toLowerCase().replace("_", "-");
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        FileConfiguration fileConfiguration = ConfigFile.PLUGIN_DATA.getFile();
        if (fileConfiguration == null) {
            return false;
        }
        String string = "alerts-disabled." + this.getId();
        return !fileConfiguration.contains(string);
    }

    public void switchState() {
        FileConfiguration fileConfiguration = ConfigFile.PLUGIN_DATA.getFile();
        if (fileConfiguration == null) {
            return;
        }
        String string = "alerts-disabled." + this.getId();
        fileConfiguration.set(string, (Object)(this.isEnabled() ? Long.valueOf(System.currentTimeMillis()) : null));
        ConfigFile.PLUGIN_DATA.saveFile();
    }
}

