/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.data.boxes;

import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.events.crafting.CraftEvent;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.events.opening.OpenEventData;
import com.xericker.mysteryboxes.core.settings.OpeningData;
import com.xericker.mysteryboxes.core.vaults.Vault;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxStatus;
import com.xericker.mysteryboxes.handlers.data.loots.Loot;
import com.xericker.mysteryboxes.handlers.data.loots.LootManager;
import com.xericker.mysteryboxes.handlers.data.loots.LootStatus;
import com.xericker.mysteryboxes.handlers.data.songs.SongData;
import com.xericker.mysteryboxes.handlers.data.songs.SongManager;
import com.xericker.mysteryboxes.handlers.data.themes.Theme;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeData;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeManager;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeStatus;
import com.xericker.mysteryboxes.handlers.data.upgrades.Upgrade;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeData;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeInterface;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeManager;
import com.xericker.mysteryboxes.handlers.placeholders.GeneralPlaceholders;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import com.xericker.mysteryboxes.playerdata.stats.Statistic;
import com.xericker.mysteryboxes.playerdata.stats.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Box {
    private FileConfiguration configFile;
    private String boxId;
    private BoxStatus boxStatus;
    private Map<Loot, Double> loots;
    private BoxSettings boxSettings;
    private OpeningSettings openingSettings;
    private CraftingSettings craftingSettings;
    private GiftingSettings giftingSettings;
    private ParticleSettings particleSettings;

    public Box(String string2, FileConfiguration fileConfiguration) {
        if (string2.isEmpty()) {
            this.boxStatus = BoxStatus.ERROR_BOX_SETTINGS;
            return;
        }
        this.boxId = string2;
        this.configFile = fileConfiguration;
        this.boxStatus = BoxStatus.ENABLED;
        this.loots = new HashMap<Loot, Double>();
        this.boxSettings = new BoxSettings();
        if (this.boxStatus != BoxStatus.ERROR_BOX_SETTINGS && !this.getBoxSettings().enabled) {
            this.boxStatus = BoxStatus.DISABLED;
            return;
        }
        if (this.boxStatus == BoxStatus.ERROR_BOX_SETTINGS) {
            return;
        }
        this.openingSettings = new OpeningSettings();
        this.craftingSettings = new CraftingSettings();
        this.giftingSettings = new GiftingSettings();
        this.particleSettings = new ParticleSettings();
        try {
            this.configFile.getStringList("opening-settings.loots-assigned").stream().map(string -> string.replaceAll("(id|chance):", "").split(";")).filter(stringArray -> ((String[])stringArray).length >= 1 && LootManager.getLoot(stringArray[0]) != null).filter(stringArray -> ((String[])stringArray).length >= 2 || LootManager.getLoot(stringArray[0]).getStatus() == LootStatus.ENABLED).forEach(stringArray -> this.loots.put(LootManager.getLoot(stringArray[0]), Double.parseDouble(stringArray[1])));
            for (Loot loot : this.loots.keySet()) {
                if (loot.getStatus() == LootStatus.ENABLED) continue;
                this.boxStatus = BoxStatus.ERROR_LOOT_SETTINGS;
                break;
            }
            if (this.loots.size() == 0) {
                this.boxStatus = BoxStatus.ERROR_LOOT_SETTINGS;
            }
        }
        catch (Exception exception) {
            this.boxStatus = BoxStatus.ERROR_LOOT_SETTINGS;
        }
    }

    public FileConfiguration getConfigFile() {
        return this.configFile;
    }

    public String getId() {
        return this.boxId;
    }

    public BoxStatus getStatus() {
        return this.boxStatus;
    }

    public Map<Loot, Double> getLoots() {
        return this.loots;
    }

    public BoxSettings getBoxSettings() {
        return this.boxSettings;
    }

    public OpeningSettings getOpeningSettings() {
        return this.openingSettings;
    }

    public CraftingSettings getCraftingSettings() {
        return this.craftingSettings;
    }

    public GiftingSettings getGiftingSettings() {
        return this.giftingSettings;
    }

    public ParticleSettings getAnimationSettings() {
        return this.particleSettings;
    }

    public boolean hasOpenPermission(Player player) {
        String string = "mysteryboxes.open.*";
        String string2 = string.replace("*", "") + this.getId();
        return player.hasPermission(string) || player.hasPermission(string2);
    }

    public boolean hasCraftPermission(Player player) {
        String string = "mysteryboxes.craft.*";
        String string2 = string.replace("*", "") + this.getId();
        return player.hasPermission(string) || player.hasPermission(string2);
    }

    public boolean hasGiftPermission(Player player) {
        String string = "mysteryboxes.gift.*";
        String string2 = string.replace("*", "") + this.getId();
        return player.hasPermission(string) || player.hasPermission(string2);
    }

    public void openBox(Player player) {
        ThemeData themeData;
        int n;
        UpgradeInterface upgradeInterface;
        PlayerData playerData = PlayerDataManager.getData(player);
        OpeningData openingData = playerData.getOpeningData();
        Vault vault = openingData.getChosenVault();
        if (vault == null) {
            return;
        }
        Box box = openingData.getChosenBox();
        int n2 = openingData.getBoxesToOpen();
        if (box == null || n2 == 0) {
            return;
        }
        UpgradeData upgradeData = UpgradeManager.getData(Upgrade.TIME_BOX);
        UpgradeInterface upgradeInterface2 = upgradeInterface = upgradeData != null ? upgradeData.getInterface() : null;
        if (upgradeInterface != null && n2 > (n = upgradeInterface.getMaxLevel())) {
            n2 = n;
        }
        Theme theme = playerData.getChosenTheme();
        if (box.getOpeningSettings().forceTheme != null) {
            theme = box.getOpeningSettings().forceTheme;
        }
        if ((themeData = ThemeManager.getData(theme)) != null && themeData.getStatus() != ThemeStatus.ENABLED) {
            theme = null;
        }
        SongData songData = SongManager.getData(playerData.getChosenSongId());
        if (box.getOpeningSettings().forceSongData != null) {
            songData = box.getOpeningSettings().forceSongData;
        }
        OpenEventData openEventData = new OpenEventData();
        openEventData.box = box;
        openEventData.boxesToOpen = n2;
        openEventData.vault = vault;
        openEventData.forceTheme = theme;
        openEventData.forceSongData = songData;
        OpenEvent openEvent = new OpenEvent(player, openEventData);
        openEvent.openBox();
        playerData.setOpenExecutor(openEvent);
        openingData.setChosenBox(null);
        openingData.setBoxesToOpen(0);
    }

    public void craftBox(Player player) {
        PlayerData playerData = PlayerDataManager.getData(player);
        OpeningData openingData = playerData.getOpeningData();
        Vault vault = openingData.getChosenVault();
        if (vault == null) {
            return;
        }
        CraftEvent craftEvent = new CraftEvent(player, this, vault);
        craftEvent.craftBox();
    }

    public void giftBox(Player player, Player player2) {
        PlayerData playerData = PlayerDataManager.getData(player);
        playerData.setGifts(this, playerData.getGifts(this) - 1);
        playerData.setDust(playerData.getDust() + this.getGiftingSettings().dustReward);
        playerData.setStatistic(Statistic.GIFTS_SENT, playerData.getStatistic(Statistic.GIFTS_SENT) + 1L);
        playerData.setTimestamp(Timestamp.GIFT_SENT, System.currentTimeMillis());
        for (String string : ConfigParser.getStringList(LanguageValue.GIFTING_SEND)) {
            String object = string.replace("{SENDER}", player.getName());
            object = object.replace("{RECEIVER}", player2.getName());
            object = GeneralPlaceholders.translate((Object)player, this, object);
            player.sendMessage(object);
        }
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 2.0f);
        PlayerData playerData2 = PlayerDataManager.getData(player2);
        playerData2.setBoxes(this, playerData2.getBoxes(this) + 1);
        playerData2.setStatistic(Statistic.GIFTS_RECEIVED, playerData2.getStatistic(Statistic.GIFTS_RECEIVED) + 1L);
        playerData2.setTimestamp(Timestamp.GIFT_RECEIVED, System.currentTimeMillis());
        for (String string : ConfigParser.getStringList(LanguageValue.GIFTING_RECEIVE)) {
            string = string.replace("{SENDER}", player.getName());
            string = string.replace("{RECEIVER}", player2.getName());
            string = GeneralPlaceholders.translate((Object)player, this, string);
            player.sendMessage(string);
        }
        player2.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
    }

    public class BoxSettings {
        public boolean enabled;
        public int priority;
        public String name;
        public List<String> description;
        public Material type;
        public int model;
        public String head;

        BoxSettings() {
            try {
                String string = "box-settings.";
                this.enabled = Box.this.configFile.getBoolean(string + "enabled");
                this.priority = Box.this.configFile.getInt(string + "priority");
                this.description = ConfigParser.getStringList(Box.this.configFile, string + "description");
                this.name = ConfigParser.getString(Box.this.configFile, string + "name");
                if (this.name == null || this.name.isEmpty()) {
                    this.name = "\u00a7c\u26a0 The name is null";
                    Box.this.boxStatus = BoxStatus.ERROR_BOX_SETTINGS;
                }
                this.type = Material.matchMaterial((String)ConfigParser.getString(Box.this.configFile, string + "type"));
                if (this.type == null) {
                    Box.this.boxStatus = BoxStatus.ERROR_BOX_SETTINGS;
                }
                this.model = Box.this.configFile.getInt(string + "model");
                this.head = Box.this.configFile.getString(string + "head");
                if (this.head == null || this.head.isEmpty()) {
                    this.head = Box.this.configFile.getString(string + "custom-head");
                }
            }
            catch (Exception exception) {
                Box.this.boxStatus = BoxStatus.ERROR_BOX_SETTINGS;
            }
        }
    }

    public class OpeningSettings {
        public boolean canBeOpened;
        public Theme forceTheme;
        public SongData forceSongData;

        /*
         * WARNING - void declaration
         */
        OpeningSettings() {
            try {
                void var4_8;
                String string = "opening-settings.";
                this.canBeOpened = Box.this.configFile.getBoolean(string + "can-be-opened");
                String string2 = Box.this.configFile.getString(string + "force-theme");
                if (string2 == null) {
                    string2 = "null";
                }
                for (Theme theme : Theme.values()) {
                    if (!string2.equalsIgnoreCase(theme.name())) continue;
                    this.forceTheme = theme;
                }
                String string3 = Box.this.configFile.getString(string + "force-song");
                if (string3 == null) {
                    String string4 = "null";
                }
                this.forceSongData = SongManager.getData((String)var4_8);
            }
            catch (Exception exception) {
                Box.this.boxStatus = BoxStatus.ERROR_OPENING_SETTINGS;
            }
        }
    }

    public class CraftingSettings {
        public boolean showInMenu;
        public boolean canBeCrafted;
        public int dustCost;

        CraftingSettings() {
            try {
                String string = "crafting-settings.";
                this.showInMenu = Box.this.configFile.getBoolean(string + "show-in-menu");
                this.canBeCrafted = Box.this.configFile.getBoolean(string + "can-be-crafted");
                this.dustCost = Box.this.configFile.getInt(string + "dust-cost");
            }
            catch (Exception exception) {
                Box.this.boxStatus = BoxStatus.ERROR_CRAFTING_SETTINGS;
            }
        }
    }

    public class GiftingSettings {
        public boolean showInMenu;
        public boolean canBeGifted;
        public int dustReward;

        GiftingSettings() {
            try {
                String string = "gifting-settings.";
                this.showInMenu = Box.this.configFile.getBoolean(string + "show-in-menu");
                this.canBeGifted = Box.this.configFile.getBoolean(string + "can-be-gifted");
                this.dustReward = Box.this.configFile.getInt(string + "dust-reward");
                if (this.dustReward < 0) {
                    Box.this.boxStatus = BoxStatus.ERROR_GIFTING_SETTINGS;
                }
            }
            catch (Exception exception) {
                Box.this.boxStatus = BoxStatus.ERROR_GIFTING_SETTINGS;
            }
        }
    }

    public class ParticleSettings {
        public List<String> spiralParticles;
        public List<String> explosionParticles;
        public List<String> idleParticles;

        ParticleSettings() {
            try {
                String string = "particle-settings.";
                this.spiralParticles = ConfigParser.getStringList(Box.this.configFile, string + "spiral-particles");
                this.explosionParticles = ConfigParser.getStringList(Box.this.configFile, string + "explosion-particles");
                this.idleParticles = ConfigParser.getStringList(Box.this.configFile, string + "idle-particles");
            }
            catch (Exception exception) {
                Box.this.boxStatus = BoxStatus.ERROR_PARTICLE_SETTINGS;
            }
        }
    }
}

