/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.data.boxes;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.config.files.ConfigValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.DefaultBox;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import libraries.ConfigAPI;
import org.bukkit.configuration.file.FileConfiguration;

public class BoxManager {
    private static final List<Box> DATA_LIST = new ArrayList<Box>();

    public static List<Box> getList() {
        return DATA_LIST;
    }

    public static Box getBox(String string) {
        return BoxManager.getList().stream().filter(box -> box.getId().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public static void registerData() {
        try {
            Object[] objectArray;
            DATA_LIST.clear();
            File file = Main.getPlugin().getDataFolder();
            File file2 = new File(file, "config/boxes");
            if (!file2.exists()) {
                file2.mkdirs();
            }
            if (Boolean.TRUE.equals(ConfigParser.getBoolean(ConfigValue.GENERATE_DEFAULT_BOXES))) {
                objectArray = DefaultBox.values();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    DefaultBox defaultBox = objectArray[i];
                    String object = defaultBox.name().toLowerCase().replace("_", "-");
                    ConfigAPI.registerConfig("box_" + object, object + ".yml", file2.getPath(), true, Main.getPlugin());
                }
            }
            if ((objectArray = file2.listFiles()) == null) {
                Main.getPlugin().getLogger().warning("The box files array is null.");
                return;
            }
            for (DefaultBox defaultBox : objectArray) {
                FileConfiguration fileConfiguration;
                String string = ((File)((Object)defaultBox)).getName();
                string = string.replace(".yml", "");
                string = string.replace(" ", "");
                string = string.trim();
                String string2 = "box_" + string;
                if (string.isEmpty()) {
                    Main.getPlugin().getLogger().warning("Failed to register box " + string + " (The ID is empty).");
                    continue;
                }
                if (BoxManager.getBox(string) != null) {
                    Main.getPlugin().getLogger().warning("Failed to register box " + string + " (Already registered).");
                    continue;
                }
                ConfigAPI.registerConfig(string2, ((File)((Object)defaultBox)).getName(), file2.getPath(), false, Main.getPlugin());
                ConfigAPI.Config config = ConfigAPI.getConfig(string2);
                FileConfiguration fileConfiguration2 = fileConfiguration = config != null ? config.getFileConfig() : null;
                if (config == null) {
                    Main.getPlugin().getLogger().warning("Failed to register box " + string + " (The config is null).");
                    continue;
                }
                Box box = new Box(string, fileConfiguration);
                DATA_LIST.add(box);
            }
        }
        catch (Exception exception) {
            Main.getPlugin().getLogger().warning("An unexpected error has occurred!");
            Main.getPlugin().getLogger().warning("Send this error to the developer:");
            exception.printStackTrace();
        }
    }
}

