/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.data.loots;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.config.files.ConfigValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.handlers.data.loots.DefaultLoot;
import com.xericker.mysteryboxes.handlers.data.loots.Loot;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import libraries.ConfigAPI;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class LootManager {
    private static final List<Loot> DATA_LIST = new ArrayList<Loot>();

    public static List<Loot> getList() {
        return DATA_LIST;
    }

    public static Loot getLoot(String string) {
        return LootManager.getList().stream().filter(loot -> loot.getId().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public static void registerData() {
        try {
            Object[] objectArray;
            DATA_LIST.clear();
            File file = Main.getPlugin().getDataFolder();
            File file2 = new File(file, "config/loots");
            if (!file2.exists()) {
                file2.mkdirs();
            }
            if (ConfigParser.getBoolean(ConfigValue.GENERATE_DEFAULT_LOOTS).booleanValue()) {
                objectArray = DefaultLoot.values();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    DefaultLoot defaultLoot = objectArray[i];
                    String object = defaultLoot.name().toLowerCase().replace("_", "-");
                    ConfigAPI.registerConfig("loot_" + object, object + ".yml", file2.getPath(), true, Main.getPlugin());
                }
            }
            if ((objectArray = file2.listFiles()) == null) {
                Main.getPlugin().getLogger().warning("The loot files array is null.");
                return;
            }
            for (DefaultLoot defaultLoot : objectArray) {
                FileConfiguration fileConfiguration;
                String string = ((File)((Object)defaultLoot)).getName();
                string = string.replace(".yml", "");
                string = string.replace(" ", "");
                string = string.trim();
                String string2 = "loot_" + string;
                if (string.isEmpty()) {
                    Main.getPlugin().getLogger().warning("Failed to register loot " + string + " (The ID is empty).");
                    continue;
                }
                if (LootManager.getLoot(string) != null) {
                    Main.getPlugin().getLogger().warning("Failed to register loot " + string + " (Already registered).");
                    continue;
                }
                ConfigAPI.registerConfig(string2, ((File)((Object)defaultLoot)).getName(), file2.getPath(), false, Main.getPlugin());
                ConfigAPI.Config config = ConfigAPI.getConfig(string2);
                FileConfiguration fileConfiguration2 = fileConfiguration = config != null ? config.getFileConfig() : null;
                if (config == null) {
                    Main.getPlugin().getLogger().warning("Failed to register loot " + string + " (The config is null).");
                    continue;
                }
                ConfigurationSection configurationSection = fileConfiguration.getConfigurationSection("loot-creator");
                if (configurationSection == null) {
                    return;
                }
                for (String string3 : configurationSection.getKeys(false)) {
                    Loot loot = new Loot(string3, fileConfiguration);
                    DATA_LIST.add(loot);
                }
            }
        }
        catch (Exception exception) {
            Main.getPlugin().getLogger().warning("Failed to register loots.");
            exception.printStackTrace();
        }
    }
}

