/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.data.songs;

import com.xericker.mysteryboxes.config.files.ConfigValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.handlers.data.songs.SongStatus;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class SongData {
    private String songId;
    private FileConfiguration configFile;
    private SongStatus songStatus;
    private GeneralSettings generalSettings;
    private UnlockSettings unlockSettings;
    private IconBuilder iconBuilder;

    public SongData(String string, FileConfiguration fileConfiguration) {
        this.songId = string;
        this.configFile = fileConfiguration;
        this.songStatus = SongStatus.ENABLED;
        this.generalSettings = new GeneralSettings();
        if (this.songStatus != SongStatus.ERROR_SONG_SETTINGS && !this.getGeneralSettings().enabled) {
            this.songStatus = SongStatus.DISABLED;
            return;
        }
        if (this.songStatus == SongStatus.ERROR_SONG_SETTINGS) {
            return;
        }
        this.generalSettings = new GeneralSettings();
        this.unlockSettings = new UnlockSettings();
        this.iconBuilder = new IconBuilder();
    }

    public String getSongId() {
        return this.songId;
    }

    public FileConfiguration getConfigFile() {
        return this.configFile;
    }

    public SongStatus getStatus() {
        return this.songStatus;
    }

    public GeneralSettings getGeneralSettings() {
        return this.generalSettings;
    }

    public UnlockSettings getUnlockSettings() {
        return this.unlockSettings;
    }

    public IconBuilder getIconBuilder() {
        return this.iconBuilder;
    }

    public boolean isUnlocked(Player player) {
        PlayerData playerData = PlayerDataManager.getData(player);
        boolean bl = playerData.getSongsUnlocked().containsKey(this.getSongId());
        boolean bl2 = this.getUnlockSettings().unlockedByDefault;
        if (bl2) {
            bl = true;
        }
        return bl;
    }

    public boolean hasPermission(Player player) {
        String string = "mysteryboxes.song.*";
        String string2 = string.replace("*", "") + this.getSongId();
        return player.hasPermission(string) || player.hasPermission(string2);
    }

    public boolean hasDust(Player player) {
        PlayerData playerData = PlayerDataManager.getData(player);
        boolean bl = playerData.getDust() >= this.getUnlockSettings().dustCost;
        boolean bl2 = ConfigParser.getBoolean(ConfigValue.UNLOCK_DUST);
        return bl2 || bl;
    }

    public class GeneralSettings {
        public boolean enabled;
        public boolean unique;
        public String name;
        public List<String> description;

        GeneralSettings() {
            try {
                String string = "general-settings.";
                this.enabled = SongData.this.configFile.getBoolean(string + "enabled");
                this.unique = SongData.this.configFile.getBoolean(string + "unique");
                this.description = ConfigParser.getStringList(SongData.this.configFile, string + "description");
                this.name = ConfigParser.getString(SongData.this.configFile, string + "name");
                if (this.name.isEmpty()) {
                    this.name = "\u00a7c\u26a0 The name is null";
                    SongData.this.songStatus = SongStatus.ERROR_SONG_SETTINGS;
                }
            }
            catch (Exception exception) {
                SongData.this.songStatus = SongStatus.ERROR_SONG_SETTINGS;
            }
        }
    }

    public class UnlockSettings {
        public int dustCost;
        public boolean unlockedByDefault;

        UnlockSettings() {
            try {
                String string = "unlock-settings.";
                this.dustCost = SongData.this.configFile.getInt(string + "dust-cost");
                this.unlockedByDefault = SongData.this.configFile.getBoolean(string + "unlocked-by-default");
            }
            catch (Exception exception) {
                SongData.this.songStatus = SongStatus.ERROR_UNLOCK_SETTINGS;
            }
        }
    }

    public class IconBuilder {
        public Material type;
        public boolean glow;
        public int amount;
        public int model;
        public String head;

        IconBuilder() {
            try {
                String string = "icon-builder.";
                this.type = Material.matchMaterial((String)ConfigParser.getString(SongData.this.configFile, string + "type"));
                if (this.type == null) {
                    SongData.this.songStatus = SongStatus.ERROR_ITEM_SETTINGS;
                }
                this.glow = SongData.this.configFile.getBoolean(string + "glow");
                this.amount = SongData.this.configFile.getInt(string + "amount");
                this.model = SongData.this.configFile.getInt(string + "model");
                this.head = SongData.this.configFile.getString(string + "head");
                if (this.head == null || this.head.isEmpty()) {
                    this.head = SongData.this.configFile.getString(string + "custom-head");
                }
            }
            catch (Exception exception) {
                SongData.this.songStatus = SongStatus.ERROR_ITEM_SETTINGS;
            }
        }
    }
}

