/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.data.themes;

import com.xericker.mysteryboxes.config.files.ConfigValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.events.opening.themes.ThemeExecutor;
import com.xericker.mysteryboxes.core.events.opening.themes.custom.ApocalypseTheme;
import com.xericker.mysteryboxes.core.events.opening.themes.custom.AstronautTheme;
import com.xericker.mysteryboxes.core.events.opening.themes.custom.HalloweenTheme;
import com.xericker.mysteryboxes.core.events.opening.themes.custom.MiningFrenzyTheme;
import com.xericker.mysteryboxes.core.events.opening.themes.custom.SummerBreezeTheme;
import com.xericker.mysteryboxes.core.events.opening.themes.custom.UnderwaterTroubleTheme;
import com.xericker.mysteryboxes.core.events.opening.themes.holiday.HolidayTheme;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeData;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import libraries.ConfigAPI;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public enum Theme {
    HOLIDAY(HolidayTheme.class),
    HALLOWEEN(HalloweenTheme.class),
    APOCALYPSE(ApocalypseTheme.class),
    MINING_FRENZY(MiningFrenzyTheme.class),
    END_ASTRONAUT(AstronautTheme.class),
    UNDERWATER_TROUBLE(UnderwaterTroubleTheme.class),
    SUMMER_BREEZE(SummerBreezeTheme.class);

    private final Class<? extends ThemeExecutor> classInstance;

    private Theme(Class<? extends ThemeExecutor> clazz) {
        this.classInstance = clazz;
    }

    public String getId() {
        return this.name().toLowerCase().replace("_", "-");
    }

    public String getConfigId() {
        return "theme_" + this.getId();
    }

    public FileConfiguration getConfig() {
        ConfigAPI.Config config = ConfigAPI.getConfig(this.getConfigId());
        if (config == null) {
            return null;
        }
        return config.getFileConfig();
    }

    public ThemeExecutor getExecutor() {
        try {
            return this.classInstance.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean hasPermission(Player player) {
        String string = "mysteryboxes.theme.*";
        String string2 = string.replace("*", "") + this.getId();
        return player.hasPermission(string) || player.hasPermission(string2);
    }

    public boolean hasDust(Player player) {
        ThemeData themeData = ThemeManager.getData(this);
        if (themeData == null) {
            return false;
        }
        PlayerData playerData = PlayerDataManager.getData(player);
        boolean bl = playerData.getDust() >= themeData.getUnlockSettings().dustCost;
        boolean bl2 = ConfigParser.getBoolean(ConfigValue.UNLOCK_DUST);
        return bl2 || bl;
    }

    public boolean isUnlocked(Player player) {
        ThemeData themeData = ThemeManager.getData(this);
        if (themeData == null) {
            return false;
        }
        PlayerData playerData = PlayerDataManager.getData(player);
        boolean bl = playerData.getThemesUnlocked().containsKey((Object)themeData.getTheme());
        boolean bl2 = themeData.getUnlockSettings().unlockedByDefault;
        if (bl2) {
            bl = true;
        }
        return bl;
    }
}

