/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.data.themes;

import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.handlers.data.themes.Theme;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeStatus;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class ThemeData {
    private FileConfiguration configFile;
    private Theme theme;
    private ThemeStatus themeStatus;
    private GeneralSettings generalSettings;
    private UnlockSettings unlockSettings;
    private IconBuilder iconBuilder;

    public ThemeData(Theme theme, FileConfiguration fileConfiguration) {
        this.configFile = fileConfiguration;
        this.theme = theme;
        this.themeStatus = ThemeStatus.ENABLED;
        this.generalSettings = new GeneralSettings();
        if (this.themeStatus != ThemeStatus.ERROR_THEME_SETTINGS && !this.generalSettings.enabled) {
            this.themeStatus = ThemeStatus.DISABLED;
            return;
        }
        if (this.themeStatus == ThemeStatus.ERROR_THEME_SETTINGS) {
            return;
        }
        this.unlockSettings = new UnlockSettings();
        this.iconBuilder = new IconBuilder();
    }

    public FileConfiguration getConfigFile() {
        return this.configFile;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public ThemeStatus getStatus() {
        return this.themeStatus;
    }

    public GeneralSettings getGeneralSettings() {
        return this.generalSettings;
    }

    public UnlockSettings getUnlockSettings() {
        return this.unlockSettings;
    }

    public IconBuilder getIconBuilder() {
        return this.iconBuilder;
    }

    public class GeneralSettings {
        public boolean enabled;
        public boolean unique;
        public String name;
        public List<String> description;

        GeneralSettings() {
            try {
                String string = "general-settings.";
                this.enabled = ThemeData.this.configFile.getBoolean(string + "enabled");
                this.unique = ThemeData.this.configFile.getBoolean(string + "unique");
                this.description = ConfigParser.getStringList(ThemeData.this.configFile, string + "description");
                this.name = ConfigParser.getString(ThemeData.this.configFile, string + "name");
                if (this.name.isEmpty()) {
                    this.name = "\u00a7c\u26a0 The name is null";
                    ThemeData.this.themeStatus = ThemeStatus.ERROR_THEME_SETTINGS;
                }
            }
            catch (Exception exception) {
                ThemeData.this.themeStatus = ThemeStatus.ERROR_THEME_SETTINGS;
            }
        }
    }

    public class UnlockSettings {
        public int dustCost;
        public boolean unlockedByDefault;

        UnlockSettings() {
            try {
                String string = "unlock-settings.";
                this.dustCost = ThemeData.this.configFile.getInt(string + "dust-cost");
                this.unlockedByDefault = ThemeData.this.configFile.getBoolean(string + "unlocked-by-default");
            }
            catch (Exception exception) {
                ThemeData.this.themeStatus = ThemeStatus.ERROR_UNLOCK_SETTINGS;
            }
        }
    }

    public class IconBuilder {
        public Material type;
        public boolean glow;
        public int amount;
        public int model;
        public String head;

        IconBuilder() {
            try {
                String string = "icon-builder.";
                this.type = Material.matchMaterial((String)ConfigParser.getString(ThemeData.this.configFile, string + "type"));
                if (this.type == null) {
                    ThemeData.this.themeStatus = ThemeStatus.ERROR_ITEM_SETTINGS;
                }
                this.glow = ThemeData.this.configFile.getBoolean(string + "glow");
                this.amount = ThemeData.this.configFile.getInt(string + "amount");
                this.model = ThemeData.this.configFile.getInt(string + "model");
                this.head = ThemeData.this.configFile.getString(string + "head");
                if (this.head == null || this.head.isEmpty()) {
                    this.head = ThemeData.this.configFile.getString(string + "custom-head");
                }
            }
            catch (Exception exception) {
                ThemeData.this.themeStatus = ThemeStatus.ERROR_ITEM_SETTINGS;
            }
        }
    }
}

