/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.data.themes;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.handlers.data.themes.Theme;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeData;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeStatus;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import libraries.ConfigAPI;

public class ThemeManager {
    private static final List<ThemeData> DATA_LIST = new ArrayList<ThemeData>();

    public static List<ThemeData> getList() {
        return DATA_LIST;
    }

    public static ThemeData getData(Theme theme) {
        return ThemeManager.getList().stream().filter(themeData -> themeData.getTheme() == theme).findFirst().orElse(null);
    }

    public static void registerData() {
        try {
            DATA_LIST.clear();
            for (Theme theme : Theme.values()) {
                String string = theme.getId();
                String string2 = theme.getConfigId();
                ConfigAPI.registerConfig(string2, "theme-", string + ".yml", Main.getPlugin().getDataFolder().getPath() + "/config/themes", true, Main.getPlugin());
                ThemeData themeData = new ThemeData(theme, theme.getConfig());
                DATA_LIST.add(themeData);
            }
        }
        catch (Exception exception) {
            Main.getPlugin().getLogger().warning("Failed to register themes.");
            exception.printStackTrace();
        }
    }

    public static boolean validateTheme(String string) {
        if (string == null) {
            return false;
        }
        for (Theme theme : Theme.values()) {
            if (!string.equalsIgnoreCase(theme.name())) continue;
            return true;
        }
        return false;
    }

    public static boolean validateTheme(UUID uUID, Theme theme) {
        boolean bl;
        ThemeData themeData = ThemeManager.getData(theme);
        boolean bl2 = bl = themeData != null && themeData.getStatus() == ThemeStatus.ENABLED && !themeData.getGeneralSettings().unique;
        if (uUID != null) {
            PlayerData playerData = PlayerDataManager.getData(uUID);
            bl = playerData.getThemesUnlocked().containsKey((Object)theme);
        }
        return bl;
    }
}

