/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.data.upgrades.data;

import com.xericker.mysteryboxes.handlers.data.upgrades.Upgrade;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeInterface;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TreasureHunterUpgrade
implements UpgradeInterface {
    private Upgrade upgrade;
    private Map<Integer, Integer> dustMap;
    private Map<Integer, Double> valuesMap;

    public TreasureHunterUpgrade(Upgrade upgrade) {
        this.upgrade = upgrade;
        FileConfiguration fileConfiguration = upgrade.getConfig();
        if (fileConfiguration == null) {
            return;
        }
        this.dustMap = new HashMap<Integer, Integer>();
        this.valuesMap = new HashMap<Integer, Double>();
        List list = fileConfiguration.getStringList("progress-builder");
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            String[] stringArray = string.split("\\|");
            String string2 = stringArray[0].trim();
            String string3 = stringArray[1].trim();
            String string4 = string2.split(":")[1].trim();
            String string5 = string3.split(":")[1].trim();
            this.dustMap.put(i, Integer.parseInt(string4));
            this.valuesMap.put(i, Double.parseDouble(string5));
        }
    }

    @Override
    public int getMaxLevel() {
        return this.dustMap.size();
    }

    @Override
    public Map<Integer, Integer> getDustMap() {
        return this.dustMap;
    }

    @Override
    public double getBonus(Object object) {
        PlayerData playerData = PlayerDataManager.getData(object instanceof UUID ? (UUID)object : ((Player)object).getUniqueId());
        int n = playerData.getUpgrade(this.upgrade) - 1;
        if (n < 0) {
            return 0.0;
        }
        if (n >= this.valuesMap.size()) {
            n = this.valuesMap.size() - 1;
        }
        return this.valuesMap.get(n);
    }
}

