/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.economy;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.config.files.ConfigValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.handlers.economy.EconomyAPI;
import com.xericker.mysteryboxes.handlers.economy.EconomyStatus;
import com.xericker.mysteryboxes.handlers.economy.banks.VaultBank;
import java.util.logging.Level;

public class EconomyHandler {
    private EconomyAPI economyAPI;
    private EconomyStatus economyStatus = EconomyStatus.INTERNAL;
    private VaultBank vaultBank;

    public EconomyHandler() {
        this.economyAPI = EconomyAPI.VAULT_API;
        boolean bl = ConfigParser.getBoolean(ConfigValue.HOOK_INTO_VAULT);
        if (!bl) {
            return;
        }
        switch (this.economyAPI) {
            case VAULT_API: {
                Main.getPlugin().getLogger().log(Level.INFO, "[ECONOMY] Hooking into VaultAPI...");
                this.vaultBank = new VaultBank();
                if (this.vaultBank.getEconomy() == null) {
                    Main.getPlugin().getLogger().warning("[ECONOMY] Couldn't hook into VaultAPI!");
                    Main.getPlugin().getLogger().warning("[ECONOMY] External economy support is disabled.");
                    return;
                }
                this.economyStatus = EconomyStatus.EXTERNAL;
                Main.getPlugin().getLogger().log(Level.INFO, "[ECONOMY] Successfully hooked into VaultAPI!");
                break;
            }
            case TOKEN_MANAGER: {
                Main.getPlugin().getLogger().warning("[ECONOMY] TokenManager is not supported yet!");
                Main.getPlugin().getLogger().warning("[ECONOMY] External economy support is disabled.");
            }
        }
    }

    public EconomyAPI getEconomyAPI() {
        return this.economyAPI;
    }

    public EconomyStatus getEconomyStatus() {
        return this.economyStatus;
    }

    public VaultBank getVaultBank() {
        return this.vaultBank;
    }
}

