/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.placeholders;

import com.xericker.mysteryboxes.config.files.ConfigValue;
import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.settings.OpeningData;
import com.xericker.mysteryboxes.core.vaults.Vault;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxStatus;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import org.bukkit.entity.Player;

public class CraftPlaceholders {
    public static CraftPlaceholder getPlaceholder(Player player, Box box) {
        PlayerData playerData = PlayerDataManager.getData(player);
        boolean bl = ConfigParser.getBoolean(ConfigValue.UNLOCK_DUST);
        OpeningData openingData = playerData.getOpeningData();
        Vault vault = openingData.getChosenVault();
        if (box.getStatus() != BoxStatus.ENABLED) {
            return CraftPlaceholder.UNAVAILABLE;
        }
        if (!box.getCraftingSettings().showInMenu) {
            return CraftPlaceholder.UNAVAILABLE;
        }
        if (!box.hasCraftPermission(player)) {
            return CraftPlaceholder.NO_PERMISSION;
        }
        if (!bl && playerData.getDust() < box.getCraftingSettings().dustCost) {
            return CraftPlaceholder.NOT_ENOUGH_DUST;
        }
        if (playerData.getVaultAction() != null || vault != null && vault.getVaultAction() != null) {
            return CraftPlaceholder.VAULT_IS_BUSY;
        }
        return CraftPlaceholder.CLICK_TO_CRAFT;
    }

    public static boolean sendMessage(Player player, Box box) {
        LanguageValue languageValue;
        CraftPlaceholder craftPlaceholder = CraftPlaceholders.getPlaceholder(player, box);
        switch (craftPlaceholder.ordinal()) {
            case 1: {
                languageValue = LanguageValue.BOX_UNAVAILABLE;
                break;
            }
            case 2: {
                languageValue = LanguageValue.GENERAL_NO_PERMISSION;
                break;
            }
            case 3: {
                languageValue = LanguageValue.DUST_NOT_ENOUGH;
                break;
            }
            case 4: {
                languageValue = LanguageValue.VAULT_BUSY;
                break;
            }
            default: {
                return true;
            }
        }
        for (String string : ConfigParser.getStringList(languageValue)) {
            player.sendMessage(string);
        }
        return false;
    }

    public static enum CraftPlaceholder {
        CLICK_TO_CRAFT,
        UNAVAILABLE,
        NO_PERMISSION,
        NOT_ENOUGH_DUST,
        VAULT_IS_BUSY;

    }
}

