/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.placeholders;

import com.xericker.mysteryboxes.Depend;
import com.xericker.mysteryboxes.Plugin;
import com.xericker.mysteryboxes.core.settings.GiftingData;
import com.xericker.mysteryboxes.core.settings.OpeningData;
import com.xericker.mysteryboxes.handlers.converters.AgoConverter;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxManager;
import com.xericker.mysteryboxes.handlers.data.loots.HistoryData;
import com.xericker.mysteryboxes.handlers.data.loots.Loot;
import com.xericker.mysteryboxes.handlers.data.songs.SongData;
import com.xericker.mysteryboxes.handlers.data.songs.SongManager;
import com.xericker.mysteryboxes.handlers.data.themes.Theme;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeData;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeManager;
import com.xericker.mysteryboxes.handlers.placeholders.UpgradePlaceholders;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import com.xericker.mysteryboxes.playerdata.stats.Statistic;
import com.xericker.mysteryboxes.playerdata.stats.Timestamp;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libraries.iridium.IridiumColorAPI;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import utils.MessageUtils;

public class GeneralPlaceholders {
    private GeneralPlaceholders() {
    }

    public static List<String> translate(Object object, Box box, Loot loot, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(GeneralPlaceholders.translate(object, box, loot, string));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static String translate(Object object, Box box, Loot loot, String string) {
        PlayerData playerData;
        Serializable serializable;
        if (string == null) {
            return string;
        }
        UUID uUID = null;
        if (object instanceof UUID) {
            serializable = (UUID)object;
            uUID = serializable;
        }
        if (object instanceof Player) {
            serializable = (Player)object;
            uUID = serializable.getUniqueId();
        }
        serializable = AgoConverter.getFormat();
        PlayerData playerData2 = playerData = uUID != null ? PlayerDataManager.getData(uUID) : null;
        if (playerData != null && Depend.PLACEHOLDER_API.isLoaded()) {
            string = PlaceholderAPI.setPlaceholders((Player)Bukkit.getPlayer((UUID)uUID), (String)string);
        }
        if (string.contains("%center%")) {
            string = string.replace("%center%", "");
            string = MessageUtils.formatCenter(string);
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        string = IridiumColorAPI.process(string);
        string = string.replace("{BOX_TYPES_AVAILABLE}", Plugin.getNumFormat().toK(BoxManager.getList().size()));
        if (playerData == null) {
            return string;
        }
        OpeningData openingData = playerData.getOpeningData();
        GiftingData giftingData = playerData.getGiftingData();
        string = string.replace("{PLAYER}", playerData.getPlayerName());
        string = string.replace("{BOXES_TO_OPEN}", Plugin.getNumFormat().toK(openingData.getBoxesToOpen()));
        string = string.replace("{BOXES_AVAILABLE}", Plugin.getNumFormat().toK(playerData.getBoxesAvailable()));
        string = string.replace("{GIFTS_AVAILABLE}", Plugin.getNumFormat().toK(playerData.getGiftsAvailable()));
        string = string.replace("{DUST_AVAILABLE}", Plugin.getNumFormat().toK(playerData.getDust()));
        for (Box box2 : BoxManager.getList()) {
            String string2 = "{BOX_AVAILABLE_" + box2.getId() + "}";
            string = string.replace(string2, Plugin.getNumFormat().toK(playerData.getBoxes(box2)));
        }
        if (box != null) {
            string = string.replace("{BOX_NAME}", box.getBoxSettings().name);
            string = string.replace("{BOX_AVAILABLE}", Plugin.getNumFormat().toK(playerData.getBoxes(box)));
            string = string.replace("{CRAFT_DUST_COST}", Plugin.getNumFormat().toK(box.getCraftingSettings().dustCost));
            string = string.replace("{GIFT_DUST_REWARD}", Plugin.getNumFormat().toK(box.getGiftingSettings().dustReward));
        }
        if (loot != null) {
            string = string.replace("{LOOT_NAME}", loot.getLootSettings().name);
        }
        string = GeneralPlaceholders.parseHistory(playerData, string);
        string = GeneralPlaceholders.parseThemes(playerData, string);
        string = GeneralPlaceholders.parseSongs(playerData, string);
        string = UpgradePlaceholders.translate(uUID, string);
        for (Statistic statistic : Statistic.values()) {
            String string3 = "{STATISTIC_" + statistic.name().toUpperCase() + "}";
            string = string.replace(string3, Plugin.getNumFormat().toK(playerData.getStatistic(statistic)));
        }
        String string4 = "???";
        for (Timestamp timestamp : Timestamp.values()) {
            void var9_12;
            String string5 = "{TIMESTAMP_" + timestamp.name().toUpperCase() + "}";
            long l = playerData.getTimestamp(timestamp);
            if (l > 0L) {
                Date date = new Date(l);
                String string6 = ((DateFormat)serializable).format(date);
            }
            string = string.replace(string5, (CharSequence)var9_12);
        }
        return string;
    }

    public static String translate(Object object, String string) {
        return GeneralPlaceholders.translate(object, null, null, string);
    }

    public static List<String> translate(Object object, List<String> list) {
        return GeneralPlaceholders.translate(object, null, null, list);
    }

    public static String translate(Object object, Box box, String string) {
        return GeneralPlaceholders.translate(object, box, null, string);
    }

    public static List<String> translate(Object object, Box box, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(GeneralPlaceholders.translate(object, box, null, string));
        }
        return arrayList;
    }

    private static String parseThemes(PlayerData playerData, String string) {
        float f = playerData.getThemesUnlocked().size();
        float f2 = Theme.values().length;
        float f3 = f / f2 * 100.0f;
        string = string.replace("{THEME_UNLOCKED}", String.valueOf(Math.round(f)));
        string = string.replace("{THEME_MAX}", String.valueOf(Math.round(f2)));
        string = string.replace("{THEME_UNLOCKED_PERCENT}", String.valueOf(Math.round(f3)));
        string = string.replace("{THEME_UNLOCKED_BAR}", Plugin.getProgressBar().parse(f, f2));
        Theme theme = playerData.getChosenTheme();
        ThemeData themeData = ThemeManager.getData(theme);
        string = string.replace("{THEME_CHOSEN_NAME}", themeData != null ? themeData.getGeneralSettings().name : "???");
        return string;
    }

    private static String parseSongs(PlayerData playerData, String string) {
        float f = SongManager.getList().size();
        float f2 = playerData.getSongsUnlocked().size();
        float f3 = f2 / f * 100.0f;
        string = string.replace("{SONG_UNLOCKED}", String.valueOf(Math.round(f2)));
        string = string.replace("{SONG_MAX}", String.valueOf(Math.round(f)));
        string = string.replace("{SONG_UNLOCKED_PERCENT}", String.valueOf(Math.round(f3)));
        string = string.replace("{SONG_UNLOCKED_BAR}", Plugin.getProgressBar().parse(f2, f));
        SongData songData = SongManager.getData(playerData.getChosenSongId());
        string = string.replace("{SONG_CHOSEN_NAME}", songData != null ? songData.getGeneralSettings().name : "???");
        return string;
    }

    private static String parseHistory(PlayerData playerData, String string) {
        Matcher matcher;
        Date date = new Date();
        ArrayList<HistoryData> arrayList = new ArrayList<HistoryData>(playerData.getHistoryList());
        Collections.reverse(arrayList);
        String string2 = "\\{HISTORY_(\\d+)_LOOT\\}";
        String string3 = "\\{HISTORY_(\\d+)_DATE\\}";
        Pattern pattern = Pattern.compile(string2);
        Pattern pattern2 = Pattern.compile(string3);
        while ((matcher = pattern.matcher(string)).find() || (matcher = pattern2.matcher(string)).find()) {
            Object object;
            int n = Integer.parseInt(matcher.group(1));
            if (n > arrayList.size()) {
                string = string.replaceAll(Pattern.quote(matcher.group()), "???");
                continue;
            }
            HistoryData historyData = (HistoryData)arrayList.get(n - 1);
            if (matcher.pattern() == pattern) {
                object = historyData.getLootName() != null ? historyData.getLootName() : "???";
                string = string.replaceAll(Pattern.quote(matcher.group()), (String)object);
            }
            if (matcher.pattern() != pattern2) continue;
            object = new Date(historyData.getAcquireTime());
            long l = date.getTime() - ((Date)object).getTime();
            long l2 = TimeUnit.SECONDS.convert(l, TimeUnit.MILLISECONDS);
            String string4 = AgoConverter.formatAgo(l2);
            String string5 = AgoConverter.translateTime(string4, l2);
            string = string.replaceAll(Pattern.quote(matcher.group()), string5);
        }
        return string;
    }
}

