/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.placeholders;

import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.settings.OpeningData;
import com.xericker.mysteryboxes.core.vaults.Vault;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxStatus;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import org.bukkit.entity.Player;

public class OpenPlaceholders {
    public static OpenPlaceholder getPlaceholder(Player player, Box box) {
        PlayerData playerData = PlayerDataManager.getData(player);
        OpeningData openingData = playerData.getOpeningData();
        Vault vault = openingData.getChosenVault();
        if (!box.getOpeningSettings().canBeOpened || box.getStatus() != BoxStatus.ENABLED) {
            return OpenPlaceholder.UNAVAILABLE;
        }
        if (!box.hasOpenPermission(player)) {
            return OpenPlaceholder.NO_PERMISSION;
        }
        if (playerData.getVaultAction() != null || vault != null && vault.getVaultAction() != null) {
            return OpenPlaceholder.VAULT_IS_BUSY;
        }
        return OpenPlaceholder.CLICK_TO_OPEN;
    }

    public static boolean sendMessage(Player player, Box box) {
        LanguageValue languageValue;
        OpenPlaceholder openPlaceholder = OpenPlaceholders.getPlaceholder(player, box);
        if (openPlaceholder == null) {
            return true;
        }
        switch (openPlaceholder.ordinal()) {
            case 1: {
                languageValue = LanguageValue.BOX_UNAVAILABLE;
                break;
            }
            case 2: {
                languageValue = LanguageValue.GENERAL_NO_PERMISSION;
                break;
            }
            case 3: {
                languageValue = LanguageValue.VAULT_BUSY;
                break;
            }
            default: {
                return true;
            }
        }
        for (String string : ConfigParser.getStringList(languageValue)) {
            player.sendMessage(string);
        }
        return false;
    }

    public static enum OpenPlaceholder {
        CLICK_TO_OPEN,
        UNAVAILABLE,
        NO_PERMISSION,
        VAULT_IS_BUSY;

    }
}

