/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.placeholders;

import com.xericker.mysteryboxes.Plugin;
import com.xericker.mysteryboxes.handlers.data.upgrades.Upgrade;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeData;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class UpgradePlaceholders {
    private UpgradePlaceholders() {
    }

    public static String translate(UpgradeData upgradeData, String string) {
        boolean bl = false;
        for (Upgrade upgrade : Upgrade.values()) {
            if (!string.contains("{" + upgrade.name())) continue;
            bl = true;
        }
        if (!bl) {
            string = string.replace("{UPGRADE", "{" + upgradeData.getUpgrade().name());
        }
        return string;
    }

    public static List<String> translate(UpgradeData upgradeData, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(UpgradePlaceholders.translate(upgradeData, string));
        }
        return arrayList;
    }

    public static String translate(Player player, String string) {
        return UpgradePlaceholders.translate(player.getUniqueId(), string);
    }

    public static String translate(UUID uUID, String string) {
        Object object;
        PlayerData playerData = PlayerDataManager.getData(uUID);
        for (Upgrade upgrade : Upgrade.values()) {
            UpgradeData upgradeData;
            String string2 = "{" + upgrade.name();
            if (!string.contains(string2) || (upgradeData = UpgradeManager.getData(upgrade)) == null) continue;
            object = upgradeData.getInterface();
            int n = playerData.getUpgrade(upgrade);
            int n2 = object.getMaxLevel();
            float f = (float)n / (float)n2 * 100.0f;
            f = Math.max(0.0f, f);
            string = string.replace(string2 + "_NAME}", upgradeData.getGeneralSettings().name);
            string = string.replace(string2 + "_DUST_COST}", String.valueOf(upgrade.getDustCost(uUID)));
            string = string.replace(string2 + "_LEVEL}", String.valueOf(n));
            string = string.replace(string2 + "_LEVEL_SYMBOL}", Plugin.getNumFormat().toRoman(n));
            string = string.replace(string2 + "_LEVEL_PERCENT}", String.valueOf(Math.round(f)));
            string = string.replace(string2 + "_MAX_LEVEL}", String.valueOf(n2));
            string = string.replace(string2 + "_MAX_LEVEL_SYMBOL}", Plugin.getNumFormat().toRoman(n2));
            string = string.replace(string2 + "_NEXT_LEVEL}", String.valueOf(n + 1));
            string = string.replace(string2 + "_NEXT_LEVEL_SYMBOL}", Plugin.getNumFormat().toRoman(n + 1));
            string = string.replace(string2 + "_PREVIOUS_LEVEL}", String.valueOf(n - 1));
            string = string.replace(string2 + "_PREVIOUS_LEVEL_SYMBOL}", Plugin.getNumFormat().toRoman(n - 1));
            string = string.replace(string2 + "_LEVEL_BAR}", Plugin.getProgressBar().parse(n, n2));
        }
        for (Upgrade upgrade : Upgrade.values()) {
            if (!string.contains(upgrade.name())) continue;
            double d = 0.0;
            object = UpgradeManager.getData(upgrade);
            if (object != null) {
                d = ((UpgradeData)object).getInterface().getBonus(uUID);
            }
            string = string.replace("{" + upgrade.name() + "_BONUS}", UpgradePlaceholders.formatValue(d));
        }
        return string;
    }

    private static String formatValue(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        return decimalFormat.format(d);
    }
}

