/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.menus;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.menus.MenuBuilder;
import com.xericker.mysteryboxes.menus.itembuilder.ItemBuilder;
import com.xericker.mysteryboxes.menus.itembuilder.ItemDisplay;
import com.xericker.mysteryboxes.menus.menus.alertsvisibility.MenuAlertsVisibility;
import com.xericker.mysteryboxes.menus.menus.craftboxes.CraftBoxesTrigger;
import com.xericker.mysteryboxes.menus.menus.craftboxes.MenuCraftBoxes;
import com.xericker.mysteryboxes.menus.menus.customizeopening.CustomizeOpeningTrigger;
import com.xericker.mysteryboxes.menus.menus.customizeopening.MenuCustomizeOpening;
import com.xericker.mysteryboxes.menus.menus.history.HistoryTrigger;
import com.xericker.mysteryboxes.menus.menus.history.MenuHistory;
import com.xericker.mysteryboxes.menus.menus.openboxes.MenuOpenBoxes;
import com.xericker.mysteryboxes.menus.menus.openboxes.OpenBoxesTrigger;
import com.xericker.mysteryboxes.menus.menus.sendgifts.MenuSendGifts;
import com.xericker.mysteryboxes.menus.menus.sendgifts.SendGiftsTrigger;
import com.xericker.mysteryboxes.menus.menus.songs.MenuSongs;
import com.xericker.mysteryboxes.menus.menus.songs.SongsTrigger;
import com.xericker.mysteryboxes.menus.menus.themes.MenuThemes;
import com.xericker.mysteryboxes.menus.menus.themes.ThemesTrigger;
import com.xericker.mysteryboxes.menus.menus.upgrades.MenuUpgrades;
import com.xericker.mysteryboxes.menus.menus.upgrades.UpgradesTrigger;
import com.xericker.mysteryboxes.menus.menus.vault.MenuVault;
import com.xericker.mysteryboxes.menus.menus.vault.VaultTrigger;
import com.xericker.mysteryboxes.menus.menus.vaultmanager.MenuVaultManager;
import com.xericker.mysteryboxes.menus.menus.vaultmanager.VaultManagerTrigger;
import com.xericker.mysteryboxes.menus.menus.yourprofile.MenuYourProfile;
import com.xericker.mysteryboxes.playerdata.menus.MenuData;
import com.xericker.mysteryboxes.playerdata.menus.MenuDataManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import libraries.ConfigAPI;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public enum Menu {
    VAULT(MenuVault.class, VaultTrigger.class),
    VAULT_MANAGER(MenuVaultManager.class, VaultManagerTrigger.class),
    OPEN_BOXES(MenuOpenBoxes.class, OpenBoxesTrigger.class),
    CRAFT_BOXES(MenuCraftBoxes.class, CraftBoxesTrigger.class),
    SEND_GIFTS(MenuSendGifts.class, SendGiftsTrigger.class),
    CUSTOMIZE_OPENING(MenuCustomizeOpening.class, CustomizeOpeningTrigger.class),
    OPENING_HISTORY(MenuHistory.class, HistoryTrigger.class),
    THEMES(MenuThemes.class, ThemesTrigger.class),
    UPGRADES(MenuUpgrades.class, UpgradesTrigger.class),
    SONGS(MenuSongs.class, SongsTrigger.class),
    YOUR_PROFILE(MenuYourProfile.class, null),
    ALERTS_VISIBILITY(MenuAlertsVisibility.class, null);

    private final Class<? extends MenuBuilder> builderClass;
    private final Class<? extends Enum<?>> triggerClass;

    private Menu(Class<? extends MenuBuilder> clazz, Class<? extends Enum<?>> clazz2) {
        this.builderClass = clazz;
        this.triggerClass = clazz2;
    }

    public Enum<?>[] getTriggerValues() {
        if (this.triggerClass == null) {
            return new Enum[0];
        }
        return this.triggerClass.getEnumConstants();
    }

    public String getId() {
        return this.name().toLowerCase().replace("_", "-");
    }

    public String getConfigId() {
        return "menu_" + this.getId();
    }

    public FileConfiguration getConfig() {
        ConfigAPI.Config config = ConfigAPI.getConfig(this.getConfigId());
        if (config == null) {
            return null;
        }
        return config.getFileConfig();
    }

    public static void registerFiles() {
        for (Menu menu : Menu.values()) {
            if (menu.getConfig() != null) {
                ConfigAPI.unregisterConfig(menu.getConfigId());
            }
            String string = menu.getId();
            String string2 = menu.getConfigId();
            ConfigAPI.registerConfig(string2, "menu-", string + ".yml", Main.getPlugin().getDataFolder().getPath() + "/config/menus", true, Main.getPlugin());
        }
    }

    public void open(Player player) {
        if (!this.hasPermission(player)) {
            for (String string : ConfigParser.getStringList(LanguageValue.GENERAL_NO_PERMISSION)) {
                player.sendMessage(string);
            }
            return;
        }
        try {
            MenuBuilder menuBuilder = this.builderClass.getDeclaredConstructor(Player.class).newInstance(player);
            menuBuilder.open(player);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean hasPermission(Player player) {
        String string = "mysteryboxes.menu.*";
        String string2 = string.replace("*", "") + this.getId();
        return player.hasPermission(string) || player.hasPermission(string2);
    }

    public boolean validateClick(Player player, InventoryClickEvent inventoryClickEvent) {
        return this.validateClick(player, null, inventoryClickEvent);
    }

    public boolean validateClick(Player player, Menu menu, InventoryClickEvent inventoryClickEvent) {
        InventoryAction[] inventoryActionArray = new InventoryAction[]{InventoryAction.PICKUP_ALL, InventoryAction.PICKUP_HALF};
        return this.validateClick(player, menu, inventoryClickEvent, inventoryActionArray);
    }

    public boolean validateClick(Player player, Menu menu, InventoryClickEvent inventoryClickEvent, InventoryAction[] inventoryActionArray) {
        MenuData menuData = MenuDataManager.getData(player);
        if (menu != null && menuData.getCurrentType() != menu) {
            return false;
        }
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return false;
        }
        if (inventoryClickEvent.getClickedInventory() == null || inventoryClickEvent.getClickedInventory() != inventoryClickEvent.getInventory()) {
            return false;
        }
        boolean bl = false;
        for (InventoryAction inventoryAction : inventoryActionArray) {
            if (inventoryClickEvent.getAction() != inventoryAction) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static List<ItemBuilder> getItems(ItemDisplay itemDisplay, FileConfiguration fileConfiguration, Player player, Inventory inventory) {
        ConfigurationSection configurationSection = fileConfiguration.getConfigurationSection("item-builder");
        if (configurationSection == null) {
            return Collections.emptyList();
        }
        return configurationSection.getKeys(false).stream().map(string -> new ItemBuilder(itemDisplay, inventory, player, fileConfiguration, (String)string, "item-builder")).collect(Collectors.toCollection(() -> new ArrayList(configurationSection.getKeys(false).size())));
    }

    public static List<Integer> getLayout(char c, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            string = string.replace(" ", "");
            stringBuilder.append(string);
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) != c) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public static boolean containsSlot(int n, List<Object> list) {
        ArrayList arrayList = new ArrayList();
        list.forEach(object -> {
            if (object instanceof Integer) {
                Integer n = (Integer)object;
                arrayList.add(n);
            } else if (object instanceof ItemBuilder) {
                ItemBuilder itemBuilder = (ItemBuilder)object;
                arrayList.addAll(itemBuilder.getSlots());
            }
        });
        return arrayList.stream().anyMatch(n2 -> n2 == n);
    }

    public static void clear(Inventory inventory, List<Object> list) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (Menu.containsSlot(i, list)) continue;
            inventory.setItem(i, null);
        }
    }

    public static void updateName(Player player, MenuBuilder menuBuilder) {
        MenuData menuData = MenuDataManager.getData(player);
        InventoryView inventoryView = player.getOpenInventory();
        if (!inventoryView.getTitle().equals(menuBuilder.getTitle())) {
            menuData.setKeepData(true);
            menuBuilder.open(player);
        }
    }

    public static void executeCommands(MenuBuilder menuBuilder, int n) {
        for (Object object : menuBuilder.getItems()) {
            ItemBuilder itemBuilder;
            if (!(object instanceof ItemBuilder) || !(itemBuilder = (ItemBuilder)object).getSlots().contains(n)) continue;
            itemBuilder.executeCommands();
            break;
        }
    }
}

