/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.menus.itembuilder;

import com.xericker.mysteryboxes.handlers.placeholders.GeneralPlaceholders;
import com.xericker.mysteryboxes.menus.itembuilder.ItemCommand;
import com.xericker.mysteryboxes.menus.itembuilder.ItemData;
import com.xericker.mysteryboxes.menus.itembuilder.ItemDisplay;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.ItemNBT;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import utils.ItemUtils;
import utils.PlayerUtils;
import utils.PluginUtils;

public class ItemBuilder {
    private ItemDisplay itemDisplay;
    private Inventory inventory;
    private Player player;
    private FileConfiguration itemConfig;
    private String itemId;
    private String pathPrefix;
    private boolean animated;
    private int animationIndex;
    private String trigger;
    private List<Integer> slots;
    private Map<String, ItemCommand> commands;
    private List<ItemData> items;
    private Map<String, String> tags;

    public ItemBuilder(ItemDisplay itemDisplay, Inventory inventory, Player player, FileConfiguration fileConfiguration, String string, String string2) {
        this.itemDisplay = itemDisplay;
        this.inventory = inventory;
        this.player = player;
        this.itemConfig = fileConfiguration;
        this.itemId = string;
        this.pathPrefix = string2;
        this.register();
    }

    public ItemBuilder(ItemDisplay itemDisplay, Player player, FileConfiguration fileConfiguration, String string, String string2) {
        this(itemDisplay, (Inventory)player.getInventory(), player, fileConfiguration, string, string2);
    }

    public ItemBuilder(ItemDisplay itemDisplay, Inventory inventory, Player player, FileConfiguration fileConfiguration, String string) {
        this(itemDisplay, inventory, player, fileConfiguration, string, null);
    }

    public ItemBuilder(ItemDisplay itemDisplay, Player player, FileConfiguration fileConfiguration, String string) {
        this(itemDisplay, (Inventory)player.getInventory(), player, fileConfiguration, string, null);
    }

    private void register() {
        String string = this.itemId + ".";
        if (this.pathPrefix != null) {
            string = this.pathPrefix + "." + this.itemId + ".";
        }
        this.commands = new HashMap<String, ItemCommand>();
        this.items = new ArrayList<ItemData>();
        this.tags = new HashMap<String, String>();
        this.slots = new ArrayList<Integer>();
        this.trigger = this.itemConfig.getString(string + "item-settings.trigger");
        this.animated = this.itemConfig.getBoolean(string + "item-settings.animated");
        this.parseItem(string);
        this.parseSlots(string);
        this.parseCommands(string);
    }

    private void parseItem(String string) {
        boolean bl;
        ConfigurationSection configurationSection = this.itemConfig.getConfigurationSection(string + "meta-builder");
        boolean bl2 = bl = configurationSection != null && configurationSection.getKeys(false).isEmpty();
        if (this.animated && bl) {
            for (String string2 : configurationSection.getKeys(false)) {
                if (!PluginUtils.isInteger(string2)) {
                    return;
                }
                int n = Integer.parseInt(string2);
                ItemData itemData = this.pathPrefix != null ? new ItemData(this.itemConfig, this.itemId, this.pathPrefix, n) : new ItemData(this.itemConfig, this.itemId, n);
                this.items.add(itemData);
            }
            return;
        }
        ItemData itemData = this.pathPrefix != null ? new ItemData(this.itemConfig, this.itemId, this.pathPrefix, 0) : new ItemData(this.itemConfig, this.itemId, 0);
        this.items.add(itemData);
    }

    private void parseSlots(String string) {
        String[] stringArray;
        String[] stringArray2;
        String string2 = this.itemConfig.getString(string + "item-settings.slot");
        if (string2 != null) {
            stringArray2 = string2.split(";");
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = "0";
        }
        for (String string3 : stringArray = stringArray2) {
            if (!PluginUtils.isInteger(string3)) continue;
            this.slots.add(Integer.parseInt(string3));
        }
    }

    private void parseCommands(String string) {
        for (String string2 : this.itemConfig.getStringList(string + "item-settings.commands")) {
            ItemCommand itemCommand = ItemCommand.AS_PLAYER;
            if (string2.contains("console->")) {
                itemCommand = ItemCommand.AS_CONSOLE;
            }
            string2 = string2.replace("player->", "");
            string2 = string2.replace("console->", "");
            this.commands.put(string2, itemCommand);
        }
    }

    public void build() {
        ItemMeta itemMeta;
        ItemData itemData = this.items.get(0);
        if (!this.validateItem()) {
            return;
        }
        if (this.animated) {
            itemData = this.items.get(this.animationIndex);
            ++this.animationIndex;
            if (this.animationIndex == this.items.size()) {
                this.animationIndex = 0;
            }
        }
        String string = GeneralPlaceholders.translate((Object)this.player, itemData.getName());
        List<String> list = GeneralPlaceholders.translate((Object)this.player, itemData.getLore());
        String string2 = GeneralPlaceholders.translate((Object)this.player, itemData.getHead());
        ItemStack itemStack = PluginUtils.isEmpty(string2) ? new ItemStack(itemData.getType()) : PlayerUtils.parseHead(string2);
        ItemUtils.setName(itemStack, string);
        ItemUtils.setLore(itemStack, list);
        ItemUtils.setDurability(itemStack, itemData.getDurability());
        if (itemData.getAmount() > 1) {
            itemStack.setAmount(itemData.getAmount());
        }
        if (itemData.getGlow()) {
            itemStack.addUnsafeEnchantment(Enchantment.SILK_TOUCH, 10);
        }
        if (itemData.getEnchants().isEmpty()) {
            ItemUtils.hideAttributes(itemStack);
        }
        if ((itemMeta = itemStack.getItemMeta()) != null) {
            itemMeta.setCustomModelData(Integer.valueOf(itemData.getModel()));
            itemStack.setItemMeta(itemMeta);
        }
        ItemNBT.add(itemStack, this.trigger, "itemTrigger");
        for (Map.Entry<String, String> object : this.tags.entrySet()) {
            ItemNBT.add(itemStack, object.getValue(), object.getKey());
        }
        for (Integer n : this.slots) {
            (this.inventory == null ? this.player.getInventory() : this.inventory).setItem(n.intValue(), itemStack);
        }
    }

    private boolean validateItem() {
        ItemData itemData = this.items.get(0);
        ItemStack itemStack = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "\u00a77item-builder:";
        String string2 = "\u00a76[Possible Solution]";
        String string3 = "  \u00a7c\u26a0 ";
        boolean bl = false;
        for (Integer n : this.slots) {
            if (n >= 0 && n - 1 <= this.inventory.getSize()) continue;
            bl = true;
            arrayList.add("");
            arrayList.add(string);
            arrayList.add(string3 + this.itemId + "\u00a77:");
            arrayList.add("    \u00a77item-settings:");
            arrayList.add("      \u00a77slot: \u00a7c\u26a0 " + n);
            arrayList.add("");
            arrayList.add(string2);
            arrayList.add("\u00a77One of the specified slots is out");
            arrayList.add("\u00a77of bounds. Specify the slot below");
            arrayList.add("\u00a77or equal to \u00a7f" + (this.inventory.getSize() - 1) + "\u00a77.");
            itemStack = ItemUtils.getItem(Material.BARRIER, 1, true, "\u00a7c\u26a0 Slot out of bounds", arrayList);
            break;
        }
        if (bl) {
            this.slots.clear();
            this.slots.add(0);
        }
        if (itemData.getType() == null && itemData.getHead() == null) {
            arrayList.add("");
            arrayList.add(string);
            arrayList.add(string3 + this.itemId + "\u00a77:");
            arrayList.add("    \u00a77meta-builder:");
            arrayList.add("      \u00a77type: \u00a7c\u26a0 ???");
            arrayList.add("      \u00a77head: \u00a7c\u26a0 ???");
            arrayList.add("");
            arrayList.add(string2);
            arrayList.add("\u00a77Specify one of the three types");
            arrayList.add("\u00a77to successfully display the item.");
            itemStack = ItemUtils.getItem(Material.BARRIER, 1, true, "\u00a7c\u26a0 Type is missing", arrayList);
        }
        if (itemStack == null && itemData.getType() == null) {
            arrayList.add("");
            arrayList.add("\u00a77item-builder:");
            arrayList.add("  \u00a7c\u26a0 " + this.itemId + "\u00a77:");
            arrayList.add("    \u00a77meta-builder:");
            arrayList.add("      \u00a77type: \u00a7c\u26a0 " + itemData.getTypeString());
            arrayList.add("");
            arrayList.add("\u00a76[Possible Solution]");
            arrayList.add("\u00a77Change the type to a valid material.");
            itemStack = ItemUtils.getItem(Material.BARRIER, 1, true, "\u00a7c\u26a0 Material is invalid", arrayList);
        }
        if (itemStack != null) {
            for (Integer n : this.slots) {
                this.inventory.setItem(n.intValue(), itemStack);
            }
        }
        return itemStack == null;
    }

    public Map<String, ItemCommand> getCommands() {
        return this.commands;
    }

    public void executeCommands() {
        for (Map.Entry<String, ItemCommand> entry : this.commands.entrySet()) {
            String string = GeneralPlaceholders.translate((Object)this.player, entry.getKey());
            if (entry.getValue() == ItemCommand.AS_PLAYER) {
                this.player.performCommand(string);
                continue;
            }
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string);
        }
    }

    public List<ItemData> getItems() {
        return this.items;
    }

    public ItemData getItem() {
        return this.items.get(0);
    }

    public String getItemId() {
        return this.itemId;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public void setSlot(int n) {
        this.slots.clear();
        this.slots.add(n);
    }

    public String getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String string) {
        this.trigger = string;
    }

    public void addTag(String string, String string2) {
        this.tags.put(string, string2);
    }

    public boolean equalsTrigger(String string) {
        return string.equalsIgnoreCase(this.trigger);
    }

    public boolean equalsTrigger(Object object) {
        return ((Enum)object).name().equalsIgnoreCase(this.trigger);
    }
}

