/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.menus.itembuilder;

import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;

public class ItemData {
    private FileConfiguration configFile;
    private String itemId;
    private String pathPrefix;
    private int index;
    private String name;
    private List<String> lore;
    private Material type;
    private String typeString;
    private int model;
    private String head;
    private boolean glow;
    private int amount;
    private int durability;
    private Map<Enchantment, Integer> enchants;

    public ItemData(FileConfiguration fileConfiguration, String string, String string2, int n) {
        this.configFile = fileConfiguration;
        this.itemId = string;
        this.pathPrefix = string2;
        this.index = n;
        this.register();
    }

    public ItemData(FileConfiguration fileConfiguration, String string, int n) {
        this.configFile = fileConfiguration;
        this.itemId = string;
        this.index = n;
        this.register();
    }

    public void register() {
        String string = this.itemId + ".meta-builder." + this.index + ".";
        if (this.index <= 0) {
            string = this.itemId + ".meta-builder.";
        }
        if (this.pathPrefix != null) {
            string = this.pathPrefix + "." + string;
        }
        this.name = ConfigParser.getString(this.configFile, string + "name");
        this.lore = ConfigParser.getStringList(this.configFile, string + "lore");
        this.glow = this.configFile.getBoolean(string + "glow");
        this.amount = this.configFile.getInt(string + "amount");
        this.durability = this.configFile.getInt(string + "durability");
        this.model = this.configFile.getInt(string + "model");
        this.enchants = new HashMap<Enchantment, Integer>();
        this.typeString = this.configFile.getString(string + "type");
        if (this.typeString != null) {
            this.type = Material.matchMaterial((String)this.typeString);
        }
        this.head = this.configFile.getString(string + "head");
        if (this.head == null || this.head.isEmpty()) {
            this.head = this.configFile.getString(string + "custom-head");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public void setLore(List<String> list) {
        this.lore = list;
    }

    public Material getType() {
        return this.type;
    }

    public void setType(Material material) {
        this.type = material;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public int getModel() {
        return this.model;
    }

    public void setModel(int n) {
        this.model = n;
    }

    public String getHead() {
        return this.head;
    }

    public void setHead(String string) {
        this.head = string;
    }

    public boolean getGlow() {
        return this.glow;
    }

    public void setGlow(boolean bl) {
        this.glow = bl;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int n) {
        this.amount = n;
    }

    public int getDurability() {
        return this.durability;
    }

    public void setDurability(int n) {
        this.durability = n;
    }

    public Map<Enchantment, Integer> getEnchants() {
        return this.enchants;
    }

    public void setEnchants(Map<Enchantment, Integer> map) {
        this.enchants = map;
    }
}

