/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.menus.menus.craftboxes;

import com.xericker.mysteryboxes.config.files.menus.CraftBoxesMenuValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.items.BoxItemBuilder;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxManager;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxStatus;
import com.xericker.mysteryboxes.handlers.placeholders.CraftPlaceholders;
import com.xericker.mysteryboxes.handlers.placeholders.GeneralPlaceholders;
import com.xericker.mysteryboxes.menus.Menu;
import com.xericker.mysteryboxes.menus.MenuBuilder;
import com.xericker.mysteryboxes.menus.MenuTrigger;
import com.xericker.mysteryboxes.menus.itembuilder.ItemBuilder;
import com.xericker.mysteryboxes.menus.itembuilder.ItemDisplay;
import com.xericker.mysteryboxes.menus.menus.craftboxes.CraftBoxesTrigger;
import com.xericker.mysteryboxes.menus.menus.openboxes.OpenBoxesTrigger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import utils.PluginUtils;

public class MenuCraftBoxes
extends MenuBuilder
implements Listener {
    public MenuCraftBoxes(Player player) {
        super(player);
    }

    @Override
    public Menu getMenu() {
        return Menu.CRAFT_BOXES;
    }

    @Override
    public void update() {
        int n;
        Menu.updateName(this.player, this);
        FileConfiguration fileConfiguration = this.getMenu().getConfig();
        if (fileConfiguration == null) {
            return;
        }
        List<ItemBuilder> list = Menu.getItems(ItemDisplay.MENU, fileConfiguration, this.player, this.inventory);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<Integer> list2 = Menu.getLayout('X', ConfigParser.getStringList(CraftBoxesMenuValue.LAYOUT_BOX_LAYOUT));
        boolean bl = ConfigParser.getBoolean(CraftBoxesMenuValue.LAYOUT_SORT_BOXES);
        HashMap<Box, Integer> hashMap = new HashMap<Box, Integer>();
        for (Box box : BoxManager.getList()) {
            if (box.getStatus() != BoxStatus.ENABLED || !box.getCraftingSettings().canBeCrafted) continue;
            if (!bl) {
                hashMap.put(box, hashMap.size());
                continue;
            }
            n = box.getBoxSettings().priority;
            hashMap.put(box, n);
        }
        int n2 = -1;
        int n3 = -1;
        n = list2.size() * (this.page - 1);
        if (this.page > 1) {
            ++n;
        }
        Map map = PluginUtils.valueSort(hashMap);
        Set set = map.entrySet();
        for (Map.Entry object : set) {
            ItemBuilder itemBuilder;
            Box box = (Box)object.getKey();
            if (++n2 < n - 1) continue;
            if (++n3 >= list2.size()) break;
            CraftPlaceholders.CraftPlaceholder craftPlaceholder = CraftPlaceholders.getPlaceholder(this.player, box);
            CraftBoxesMenuValue craftBoxesMenuValue = null;
            switch (craftPlaceholder) {
                case CLICK_TO_CRAFT: {
                    craftBoxesMenuValue = CraftBoxesMenuValue.BOX_STATUS_CLICK_TO_CRAFT;
                    break;
                }
                case UNAVAILABLE: {
                    craftBoxesMenuValue = CraftBoxesMenuValue.BOX_STATUS_UNAVAILABLE;
                    break;
                }
                case NO_PERMISSION: {
                    craftBoxesMenuValue = CraftBoxesMenuValue.BOX_STATUS_NO_PERMISSION;
                    break;
                }
                case NOT_ENOUGH_DUST: {
                    craftBoxesMenuValue = CraftBoxesMenuValue.BOX_STATUS_NOT_ENOUGH_DUST;
                    break;
                }
                case VAULT_IS_BUSY: {
                    craftBoxesMenuValue = CraftBoxesMenuValue.BOX_STATUS_VAULT_IS_BUSY;
                }
            }
            ItemBuilder itemBuilder2 = null;
            ItemStack itemStack = Menu.getItems(ItemDisplay.MENU, fileConfiguration, this.player, this.inventory).iterator();
            while (itemStack.hasNext()) {
                itemBuilder = itemStack.next();
                if (!itemBuilder.equalsTrigger((Object)CraftBoxesTrigger.BOX_INSTANCE)) continue;
                itemBuilder2 = itemBuilder;
            }
            if (itemBuilder2 == null || (itemBuilder = (itemStack = BoxItemBuilder.getItem(this.player, box, true)).getItemMeta()) == null) continue;
            String string = itemBuilder2.getItem().getName();
            string = GeneralPlaceholders.translate((Object)this.player, box, string);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string2 : itemBuilder2.getItem().getLore()) {
                List list3 = itemBuilder.getLore();
                if (string2.contains("{BOX_DESCRIPTION") && list3 != null) {
                    arrayList2.addAll(list3);
                    continue;
                }
                String string3 = ConfigParser.getString(craftBoxesMenuValue);
                if (string3 == null) {
                    string3 = "\u00a7c\u26a0 Placeholder is null";
                }
                string2 = string2.replace("{STATUS_PLACEHOLDER}", string3);
                string2 = GeneralPlaceholders.translate((Object)this.player, box, string2);
                arrayList2.add(string2);
            }
            itemBuilder2.getItem().setName(string);
            itemBuilder2.getItem().setLore(arrayList2);
            itemBuilder2.getItem().setType(itemStack.getType());
            itemBuilder2.getItem().setModel(box.getBoxSettings().model);
            Object object2 = box.getBoxSettings().head;
            object2 = GeneralPlaceholders.translate((Object)this.player, (String)object2);
            itemBuilder2.getItem().setHead((String)object2);
            itemBuilder2.addTag("boxId", box.getId());
            itemBuilder2.setSlot(list2.get(n3));
            itemBuilder2.build();
            arrayList.add(itemBuilder2);
        }
        for (ItemBuilder itemBuilder : list) {
            if (this.page > 1 && itemBuilder.equalsTrigger((Object)MenuTrigger.PREVIOUS_PAGE)) {
                itemBuilder.build();
                arrayList.add(itemBuilder);
                continue;
            }
            if (n >= n2 - list2.size() || !itemBuilder.equalsTrigger((Object)MenuTrigger.NEXT_PAGE)) continue;
            itemBuilder.build();
            arrayList.add(itemBuilder);
        }
        if (hashMap.isEmpty()) {
            for (ItemBuilder itemBuilder : list) {
                if (!itemBuilder.equalsTrigger((Object)OpenBoxesTrigger.NO_BOXES)) continue;
                itemBuilder.build();
                arrayList.add(itemBuilder);
            }
        }
        for (ItemBuilder itemBuilder : list) {
            if (Arrays.stream(CraftBoxesTrigger.values()).anyMatch(itemBuilder::equalsTrigger) || itemBuilder.equalsTrigger((Object)MenuTrigger.PREVIOUS_PAGE) || itemBuilder.equalsTrigger((Object)MenuTrigger.NEXT_PAGE)) continue;
            itemBuilder.build();
            arrayList.add(itemBuilder);
        }
        this.items.clear();
        this.items.addAll(arrayList);
        Menu.clear(this.inventory, arrayList);
    }

    @Override
    public int getRows() {
        int n = ConfigParser.getInt(CraftBoxesMenuValue.MENU_ROWS);
        if ((n = Math.min(n, 6)) <= 0) {
            n = 6;
        }
        return n;
    }

    @Override
    public String getTitle() {
        CraftBoxesMenuValue craftBoxesMenuValue = this.page <= 1 ? CraftBoxesMenuValue.MENU_TITLE : CraftBoxesMenuValue.TITLE_WITH_PAGES;
        String string = ConfigParser.getString(craftBoxesMenuValue);
        if (string != null) {
            string = string.replace("{PAGE}", String.valueOf(this.page));
        }
        if (string == null) {
            string = "\u00a7c\u26a0 Title is null";
        }
        return string;
    }
}

