/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.menus.menus.openboxes;

import com.xericker.mysteryboxes.core.filters.BoxFilter;
import com.xericker.mysteryboxes.core.settings.OpeningData;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxManager;
import com.xericker.mysteryboxes.handlers.placeholders.OpenPlaceholders;
import com.xericker.mysteryboxes.menus.Menu;
import com.xericker.mysteryboxes.menus.MenuBuilder;
import com.xericker.mysteryboxes.menus.MenuTrigger;
import com.xericker.mysteryboxes.playerdata.menus.MenuData;
import com.xericker.mysteryboxes.playerdata.menus.MenuDataManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.Objects;
import misc.ItemNBT;
import misc.MenuSound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MenuEventOpenBoxes
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        Object object;
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        MenuData menuData = MenuDataManager.getData(player);
        if (menuData.getCurrentType() == null) {
            return;
        }
        PlayerData playerData = PlayerDataManager.getData(player);
        MenuBuilder menuBuilder = menuData.getMenu();
        if (!menuData.getCurrentType().validateClick(player, Menu.OPEN_BOXES, inventoryClickEvent)) {
            return;
        }
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (ItemNBT.contains(itemStack, "itemTrigger")) {
            object = ItemNBT.getString(itemStack, "itemTrigger");
            if (Objects.equals(object, MenuTrigger.PREVIOUS_PAGE.name())) {
                menuBuilder.setPage(menuBuilder.getPage() - 1);
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
            if (Objects.equals(object, MenuTrigger.NEXT_PAGE.name())) {
                menuBuilder.setPage(menuBuilder.getPage() + 1);
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
            BoxFilter boxFilter = null;
            if (Objects.equals(object, MenuTrigger.MERGE_BOXES_ENABLED.name())) {
                boxFilter = BoxFilter.SHOW_ALL;
            } else if (Objects.equals(object, MenuTrigger.MERGE_BOXES_DISABLED.name())) {
                boxFilter = BoxFilter.MERGE_BOXES;
            }
            if (boxFilter != null) {
                playerData.setBoxFilter(boxFilter);
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
        }
        if (!ItemNBT.contains(itemStack, "boxId")) {
            return;
        }
        object = BoxManager.getBox(ItemNBT.getString(itemStack, "boxId"));
        boolean bl = OpenPlaceholders.sendMessage(player, (Box)object);
        if (!bl) {
            MenuSound.ERROR.play(player);
            return;
        }
        OpeningData openingData = playerData.getOpeningData();
        openingData.setChosenBox((Box)object);
        openingData.setBoxesToOpen(1);
        Menu.CUSTOMIZE_OPENING.open(player);
        MenuSound.CHEST_OPEN.play(player);
    }
}

