/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.menus.menus.themes;

import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.filters.FilterType;
import com.xericker.mysteryboxes.handlers.data.themes.Theme;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeManager;
import com.xericker.mysteryboxes.menus.Menu;
import com.xericker.mysteryboxes.menus.MenuBuilder;
import com.xericker.mysteryboxes.menus.MenuTrigger;
import com.xericker.mysteryboxes.menus.menus.themes.ThemesTrigger;
import com.xericker.mysteryboxes.playerdata.menus.MenuData;
import com.xericker.mysteryboxes.playerdata.menus.MenuDataManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.Objects;
import misc.ItemNBT;
import misc.MenuSound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MenuEventThemes
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        Object object;
        Object object2;
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        MenuData menuData = MenuDataManager.getData(player);
        if (menuData.getCurrentType() == null) {
            return;
        }
        PlayerData playerData = PlayerDataManager.getData(player);
        MenuBuilder menuBuilder = menuData.getMenu();
        if (!menuData.getCurrentType().validateClick(player, Menu.THEMES, inventoryClickEvent)) {
            return;
        }
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (ItemNBT.contains(itemStack, "itemTrigger")) {
            object2 = ItemNBT.getString(itemStack, "itemTrigger");
            if (Objects.equals(object2, MenuTrigger.PREVIOUS_PAGE.name())) {
                menuBuilder.setPage(menuBuilder.getPage() - 1);
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
            if (Objects.equals(object2, MenuTrigger.NEXT_PAGE.name())) {
                menuBuilder.setPage(menuBuilder.getPage() + 1);
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
            if (object2.equals(ThemesTrigger.RESET_THEME.name())) {
                playerData.setChosenTheme(null);
                menuBuilder.update();
                MenuSound.NOTIFY.play(player);
            }
            object = null;
            if (Objects.equals(object2, MenuTrigger.FILTER_ALL.name())) {
                object = FilterType.OWNED;
            } else if (Objects.equals(object2, MenuTrigger.FILTER_OWNED.name())) {
                object = FilterType.UNOWNED;
            } else if (Objects.equals(object2, MenuTrigger.FILTER_UNOWNED.name())) {
                object = FilterType.ALL;
            }
            if (object != null) {
                menuData.setFilterType((FilterType)((Object)object));
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
        }
        if (!ItemNBT.contains(itemStack, "themeType")) {
            return;
        }
        object2 = Theme.valueOf(ItemNBT.getString(itemStack, "themeType"));
        object = ThemeManager.getData((Theme)((Object)object2));
        if (object == null) {
            return;
        }
        if (!((Theme)((Object)object2)).isUnlocked(player)) {
            if (!((Theme)((Object)object2)).hasPermission(player)) {
                for (String string : ConfigParser.getStringList(LanguageValue.GENERAL_NO_PERMISSION)) {
                    player.sendMessage(string);
                }
                MenuSound.PURCHASE_FAILED.play(player);
                return;
            }
            if (!((Theme)((Object)object2)).hasDust(player)) {
                for (String string : ConfigParser.getStringList(LanguageValue.DUST_NOT_ENOUGH)) {
                    player.sendMessage(string);
                }
                MenuSound.PURCHASE_FAILED.play(player);
                return;
            }
            playerData.setDust(playerData.getDust() - object.getUnlockSettings().dustCost);
            playerData.getThemesUnlocked().put((Theme)((Object)object2), System.currentTimeMillis());
            playerData.setChosenTheme((Theme)((Object)object2));
            menuBuilder.update();
            MenuSound.PURCHASE_SUCCESS.play(player);
            return;
        }
        if (playerData.getChosenTheme() == object2) {
            MenuSound.ERROR.play(player);
            return;
        }
        playerData.setChosenTheme((Theme)((Object)object2));
        menuBuilder.update();
        MenuSound.SELECT.play(player);
    }
}

