/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.menus.menus.vault;

import com.xericker.mysteryboxes.config.files.menus.VaultMenuValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.songpack.SongPackRequest;
import com.xericker.mysteryboxes.menus.Menu;
import com.xericker.mysteryboxes.menus.MenuBuilder;
import com.xericker.mysteryboxes.menus.itembuilder.ItemBuilder;
import com.xericker.mysteryboxes.menus.itembuilder.ItemDisplay;
import com.xericker.mysteryboxes.menus.menus.vault.VaultTrigger;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class MenuVault
extends MenuBuilder
implements Listener {
    public MenuVault(Player player) {
        super(player);
    }

    @Override
    public Menu getMenu() {
        return Menu.VAULT;
    }

    @Override
    public void update() {
        Menu.updateName(this.player, this);
        FileConfiguration fileConfiguration = this.getMenu().getConfig();
        if (fileConfiguration == null) {
            return;
        }
        List<ItemBuilder> list = Menu.getItems(ItemDisplay.MENU, fileConfiguration, this.player, this.inventory);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        SongPackRequest songPackRequest = this.playerData.getSongPackRequest();
        if (songPackRequest == null) {
            songPackRequest = new SongPackRequest(this.player);
            songPackRequest.sendPack();
            this.playerData.setSongPackRequest(songPackRequest);
        }
        for (ItemBuilder itemBuilder : list) {
            boolean bl = itemBuilder.equalsTrigger((Object)VaultTrigger.SYNCING_DATA);
            if (bl && this.playerData.isDataSynced() || !bl && !this.playerData.isDataSynced()) continue;
            boolean bl2 = itemBuilder.equalsTrigger("OPEN_" + Menu.VAULT_MANAGER.name());
            boolean bl3 = itemBuilder.equalsTrigger("OPEN_" + Menu.ALERTS_VISIBILITY.name());
            if ((bl2 || bl3) && !this.player.isOp()) continue;
            itemBuilder.build();
            arrayList.add(itemBuilder);
        }
        this.items.clear();
        this.items.addAll(arrayList);
        Menu.clear(this.inventory, arrayList);
    }

    @Override
    public int getRows() {
        int n = ConfigParser.getInt(VaultMenuValue.MENU_ROWS);
        if ((n = Math.min(n, 6)) <= 0) {
            n = 6;
        }
        return n;
    }

    @Override
    public String getTitle() {
        VaultMenuValue vaultMenuValue = this.page <= 1 ? VaultMenuValue.MENU_TITLE : VaultMenuValue.TITLE_WITH_PAGES;
        String string = ConfigParser.getString(vaultMenuValue);
        if (string != null) {
            string = string.replace("{PAGE}", String.valueOf(this.page));
        }
        if (string == null) {
            string = "\u00a7c\u26a0 Title is null";
        }
        return string;
    }
}

