/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.menus.menus.vaultmanager;

import com.xericker.mysteryboxes.core.vaults.Vault;
import com.xericker.mysteryboxes.core.vaults.VaultAction;
import com.xericker.mysteryboxes.core.vaults.VaultData;
import com.xericker.mysteryboxes.core.vaults.editor.EditorHandler;
import com.xericker.mysteryboxes.menus.Menu;
import com.xericker.mysteryboxes.menus.MenuBuilder;
import com.xericker.mysteryboxes.menus.MenuTrigger;
import com.xericker.mysteryboxes.menus.menus.vaultmanager.VaultManagerTrigger;
import com.xericker.mysteryboxes.playerdata.menus.MenuData;
import com.xericker.mysteryboxes.playerdata.menus.MenuDataManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.Objects;
import java.util.UUID;
import misc.ItemNBT;
import misc.MenuSound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MenuEventVaultManager
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        String string;
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        MenuData menuData = MenuDataManager.getData(player);
        if (menuData.getCurrentType() == null) {
            return;
        }
        PlayerData playerData = PlayerDataManager.getData(player);
        MenuBuilder menuBuilder = menuData.getMenu();
        if (!menuData.getCurrentType().validateClick(player, Menu.VAULT_MANAGER, inventoryClickEvent)) {
            return;
        }
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (ItemNBT.contains(itemStack, "vaultId")) {
            string = ItemNBT.getString(itemStack, "vaultId");
            Vault vault = VaultData.getVault(UUID.fromString(string));
            if (vault == null) {
                return;
            }
            if (inventoryClickEvent.getAction() == InventoryAction.PICKUP_HALF) {
                player.closeInventory();
                EditorHandler.removeVault(player, vault.getVaultLoc());
            } else {
                player.closeInventory();
                player.teleport(vault.getVaultLoc().add(0.5, 1.0, 0.5));
            }
        }
        if (!ItemNBT.contains(itemStack, "itemTrigger")) {
            return;
        }
        string = ItemNBT.getString(itemStack, "itemTrigger");
        if (Objects.equals(string, MenuTrigger.PREVIOUS_PAGE.name())) {
            menuBuilder.setPage(menuBuilder.getPage() - 1);
            menuBuilder.update();
            MenuSound.SUCCESS.play(player);
        }
        if (Objects.equals(string, MenuTrigger.NEXT_PAGE.name())) {
            menuBuilder.setPage(menuBuilder.getPage() + 1);
            menuBuilder.update();
            MenuSound.SUCCESS.play(player);
        }
        boolean bl = Objects.equals(string, VaultManagerTrigger.EDITOR_DISABLED.name());
        boolean bl2 = Objects.equals(string, VaultManagerTrigger.EDITOR_ENABLED.name());
        if (bl || bl2) {
            if (playerData.getVaultAction() == VaultAction.VAULT_EDITOR) {
                EditorHandler.disableEditor(player);
            } else {
                EditorHandler.enableEditor(player);
            }
            player.closeInventory();
        }
    }
}

