/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.mysql;

import com.xericker.mysteryboxes.config.files.ConfigValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SQLCredentials {
    private final String path;
    private final String driver;
    private final String variables;
    private final String host;
    private final String port;
    private final String name;
    private final String user;
    private final String pass;

    public SQLCredentials() {
        ConfigValue[] configValueArray = new ConfigValue[]{ConfigValue.MYSQL_PATH, ConfigValue.MYSQL_DRIVER, ConfigValue.MYSQL_VARIABLES, ConfigValue.MYSQL_HOST, ConfigValue.MYSQL_PORT, ConfigValue.MYSQL_NAME, ConfigValue.MYSQL_USER, ConfigValue.MYSQL_PASS};
        Map<ConfigValue, String> map = ConfigParser.getStringValues(configValueArray);
        this.path = map.get(ConfigValue.MYSQL_PATH);
        this.driver = map.get(ConfigValue.MYSQL_DRIVER);
        this.variables = map.get(ConfigValue.MYSQL_VARIABLES);
        this.host = map.get(ConfigValue.MYSQL_HOST);
        this.port = map.get(ConfigValue.MYSQL_PORT);
        this.name = map.get(ConfigValue.MYSQL_NAME);
        this.user = map.get(ConfigValue.MYSQL_USER);
        this.pass = map.get(ConfigValue.MYSQL_PASS);
    }

    public boolean validateCredentials() {
        return StringUtils.isNotBlank((String)this.host) && StringUtils.isNotBlank((String)this.port) && StringUtils.isNotBlank((String)this.name) && StringUtils.isNotBlank((String)this.user) && StringUtils.isNotBlank((String)this.pass);
    }

    public boolean validateDriver() {
        return StringUtils.isNotBlank((String)this.path) && StringUtils.isNotBlank((String)this.driver);
    }

    public String getPath() {
        return this.path;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getVariables() {
        return this.variables;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.user;
    }

    public String getPass() {
        return this.pass;
    }
}

