/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.playerdata.player;

import com.xericker.mysteryboxes.Plugin;
import com.xericker.mysteryboxes.config.files.ConfigValue;
import com.xericker.mysteryboxes.config.files.menus.OpenBoxesMenuValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.filters.BoxFilter;
import com.xericker.mysteryboxes.core.settings.GiftingData;
import com.xericker.mysteryboxes.core.settings.OpeningData;
import com.xericker.mysteryboxes.core.songpack.SongPackRequest;
import com.xericker.mysteryboxes.core.vaults.VaultAction;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxManager;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxStatus;
import com.xericker.mysteryboxes.handlers.data.loots.HistoryData;
import com.xericker.mysteryboxes.handlers.data.loots.Loot;
import com.xericker.mysteryboxes.handlers.data.themes.Theme;
import com.xericker.mysteryboxes.handlers.data.upgrades.Upgrade;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeData;
import com.xericker.mysteryboxes.handlers.economy.EconomyHandler;
import com.xericker.mysteryboxes.handlers.economy.EconomyInjection;
import com.xericker.mysteryboxes.handlers.economy.EconomyStatus;
import com.xericker.mysteryboxes.playerdata.stats.Statistic;
import com.xericker.mysteryboxes.playerdata.stats.Timestamp;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class PlayerData {
    private UUID playerId;
    private String playerName;
    private AtomicBoolean dataSynced;
    private Map<Statistic, Long> statistics = new EnumMap<Statistic, Long>(Statistic.class);
    private Map<Timestamp, Long> timestamps = new EnumMap<Timestamp, Long>(Timestamp.class);
    private Map<String, Long> cooldowns = new HashMap<String, Long>();
    private Map<Box, Integer> boxes = new HashMap<Box, Integer>();
    private Map<Box, Integer> gifts = new HashMap<Box, Integer>();
    private List<Loot> lootDiscovered = new ArrayList<Loot>();
    private List<HistoryData> lootHistory = new ArrayList<HistoryData>();
    private Map<Upgrade, Integer> upgrades = new EnumMap<Upgrade, Integer>(Upgrade.class);
    private Map<Theme, Long> themesUnlocked = new EnumMap<Theme, Long>(Theme.class);
    private Theme chosenTheme;
    private Map<String, Long> songsUnlocked = new HashMap<String, Long>();
    private SongPackRequest songPackRequest;
    private String chosenSongId;
    private int dust;
    private VaultAction vaultAction;
    private BoxFilter boxFilter;
    private OpenEvent openEvent;
    private OpeningData openingData;
    private GiftingData giftingData;

    public PlayerData(UUID uUID) {
        this.playerId = uUID;
        this.dataSynced = new AtomicBoolean(false);
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String string) {
        this.playerName = string;
    }

    public boolean isDataSynced() {
        return this.dataSynced.get();
    }

    public void setDataSynced(boolean bl) {
        this.dataSynced.set(bl);
    }

    public Map<Statistic, Long> getStatistics() {
        return this.statistics;
    }

    public long getStatistic(Statistic statistic) {
        return this.statistics.getOrDefault((Object)statistic, 0L);
    }

    public void setStatistic(Statistic statistic, long l) {
        if (l < 0L) {
            l = 0L;
        }
        this.statistics.put(statistic, l);
    }

    public Map<Timestamp, Long> getTimestamps() {
        return this.timestamps;
    }

    public long getTimestamp(Timestamp timestamp) {
        return this.timestamps.getOrDefault((Object)timestamp, 0L);
    }

    public void setTimestamp(Timestamp timestamp, long l) {
        if (l < 0L) {
            l = 0L;
        }
        this.timestamps.put(timestamp, l);
    }

    public boolean isOnCooldown(String string) {
        return this.getCooldown(string, TimeUnit.SECONDS) > 0L;
    }

    public long getCooldown(String string, TimeUnit timeUnit) {
        long l = timeUnit.convert(this.cooldowns.getOrDefault(string, 0L) - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        if (l < 0L) {
            l = 0L;
        }
        return l;
    }

    public long getCooldown(String string) {
        return this.cooldowns.getOrDefault(string, 0L);
    }

    public void setCooldown(String string, TimeUnit timeUnit, long l) {
        this.cooldowns.put(string, System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(l, timeUnit));
    }

    public void setCooldown(String string, long l) {
        if (l < 0L) {
            l = 0L;
        }
        this.cooldowns.put(string, l);
    }

    public Map<Box, Integer> getBoxes() {
        return this.boxes;
    }

    public int getBoxes(Box box) {
        return this.boxes.getOrDefault(box, 0);
    }

    public void setBoxes(Box box, int n) {
        if (n < 0) {
            n = 0;
        }
        this.boxes.put(box, n);
    }

    public int getBoxesAvailable() {
        int n = 0;
        boolean bl = ConfigParser.getBoolean(ConfigValue.UNLOCK_BOXES);
        for (Box box : BoxManager.getList()) {
            if (box.getStatus() != BoxStatus.ENABLED) continue;
            if (bl && this.getBoxes(box) == 0) {
                ++n;
                continue;
            }
            n += this.getBoxes(box);
        }
        return n;
    }

    public BoxFilter getBoxFilter() {
        boolean bl = ConfigParser.getBoolean(OpenBoxesMenuValue.LAYOUT_MERGE_BOXES);
        if (bl && this.boxFilter == null) {
            this.boxFilter = BoxFilter.MERGE_BOXES;
        }
        return this.boxFilter == null ? BoxFilter.SHOW_ALL : this.boxFilter;
    }

    public void setBoxFilter(BoxFilter boxFilter) {
        this.boxFilter = boxFilter;
    }

    public Map<Box, Integer> getGifts() {
        return this.gifts;
    }

    public int getGifts(Box box) {
        return this.gifts.getOrDefault(box, 0);
    }

    public void setGifts(Box box, int n) {
        if (n < 0) {
            n = 0;
        }
        this.gifts.put(box, n);
    }

    public int getGiftsAvailable() {
        int n = 0;
        boolean bl = ConfigParser.getBoolean(ConfigValue.UNLOCK_GIFTS);
        for (Box box : BoxManager.getList()) {
            if (box.getStatus() != BoxStatus.ENABLED) continue;
            if (bl && this.getGifts(box) == 0) {
                ++n;
                continue;
            }
            n += this.getGifts(box);
        }
        return n;
    }

    public List<Loot> getLootDiscovered() {
        return this.lootDiscovered;
    }

    public boolean isLootDiscovered(Loot loot) {
        for (Loot loot2 : this.lootDiscovered) {
            if (!loot2.getId().equalsIgnoreCase(loot.getId())) continue;
            return true;
        }
        return false;
    }

    public List<HistoryData> getHistoryList() {
        return this.lootHistory;
    }

    public int getDust() {
        EconomyHandler economyHandler = Plugin.getEconomyManager();
        if (economyHandler.getEconomyStatus() == EconomyStatus.EXTERNAL) {
            EconomyInjection economyInjection = new EconomyInjection(this.playerId);
            return economyInjection.getCurrency();
        }
        return this.dust;
    }

    public void setDust(int n) {
        EconomyHandler economyHandler;
        if (n < 0) {
            n = 0;
        }
        if ((economyHandler = Plugin.getEconomyManager()).getEconomyStatus() == EconomyStatus.EXTERNAL) {
            EconomyInjection economyInjection = new EconomyInjection(this.playerId);
            economyInjection.setCurrency(n);
        }
        this.dust = n;
    }

    public int getUpgrade(Upgrade upgrade) {
        return this.upgrades.getOrDefault((Object)upgrade, 0);
    }

    public void setUpgrade(Upgrade upgrade, int n) {
        this.upgrades.put(upgrade, n);
    }

    public void setUpgrade(UpgradeData upgradeData, int n) {
        if (upgradeData == null) {
            return;
        }
        this.setUpgrade(upgradeData.getUpgrade(), n);
    }

    public Map<Theme, Long> getThemesUnlocked() {
        return this.themesUnlocked;
    }

    public Theme getChosenTheme() {
        return this.chosenTheme;
    }

    public void setChosenTheme(Theme theme) {
        this.chosenTheme = theme;
    }

    public Map<String, Long> getSongsUnlocked() {
        return this.songsUnlocked;
    }

    public String getChosenSongId() {
        return this.chosenSongId;
    }

    public void setChosenSongId(String string) {
        this.chosenSongId = string;
    }

    public SongPackRequest getSongPackRequest() {
        return this.songPackRequest;
    }

    public void setSongPackRequest(SongPackRequest songPackRequest) {
        this.songPackRequest = songPackRequest;
    }

    public VaultAction getVaultAction() {
        return this.vaultAction;
    }

    public void setVaultAction(VaultAction vaultAction) {
        this.vaultAction = vaultAction;
    }

    public OpeningData getOpeningData() {
        if (this.openingData == null) {
            this.openingData = new OpeningData();
        }
        return this.openingData;
    }

    public GiftingData getGiftingData() {
        if (this.giftingData == null) {
            this.giftingData = new GiftingData();
        }
        return this.giftingData;
    }

    public void clearGiftingData() {
        this.giftingData = null;
    }

    public OpenEvent getOpenExecutor() {
        return this.openEvent;
    }

    public void setOpenExecutor(OpenEvent openEvent) {
        this.openEvent = openEvent;
    }
}

