/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.playerdata.player;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.Plugin;
import com.xericker.mysteryboxes.config.files.ConfigValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.mysql.SQLConnection;
import com.xericker.mysteryboxes.playerdata.menus.MenuDataManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerIdentifier;
import com.xericker.mysteryboxes.playerdata.sync.files.FileSync;
import com.xericker.mysteryboxes.playerdata.sync.sql.SQLSync;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerDataManager {
    private static final List<PlayerData> DATA_LIST = new ArrayList<PlayerData>();

    private PlayerDataManager() {
    }

    public static List<PlayerData> getDataList() {
        return DATA_LIST;
    }

    public static PlayerData getData(Player player) {
        return PlayerDataManager.getData(player.getUniqueId());
    }

    public static PlayerData getData(UUID uUID) {
        for (PlayerData playerData : DATA_LIST) {
            if (!playerData.getPlayerId().equals(uUID)) continue;
            return playerData;
        }
        PlayerDataManager.createData(uUID);
        return PlayerDataManager.getData(uUID);
    }

    public static PlayerData getData(Player player, int n) {
        return PlayerDataManager.getData(player.getUniqueId(), n);
    }

    public static PlayerData getData(UUID uUID, int n) {
        for (PlayerData playerData : DATA_LIST) {
            if (!playerData.getPlayerId().equals(uUID)) continue;
            return playerData;
        }
        PlayerDataManager.createData(uUID, n);
        return PlayerDataManager.getData(uUID);
    }

    public static void createData(UUID uUID) {
        int n = ConfigParser.getInt(ConfigValue.MYSQL_LOAD_DELAY);
        PlayerDataManager.createData(uUID, n);
    }

    public static void createData(UUID uUID, int n) {
        PlayerDataManager.removeData(uUID);
        PlayerData playerData = new PlayerData(uUID);
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player != null) {
            PlayerIdentifier.writeId(player.getName(), uUID);
            PlayerIdentifier.writeName(uUID, player.getName());
            playerData.setPlayerName(player.getName());
        } else {
            String string = PlayerIdentifier.getName(uUID);
            if (string != null) {
                playerData.setPlayerName(string);
            }
        }
        DATA_LIST.add(playerData);
        PlayerDataManager.loadData(playerData, n);
    }

    public static void removeData(UUID uUID) {
        ArrayList<PlayerData> arrayList = new ArrayList<PlayerData>();
        for (PlayerData playerData : DATA_LIST) {
            if (playerData == null || playerData.getPlayerId() == null || !playerData.getPlayerId().equals(uUID)) continue;
            arrayList.add(playerData);
        }
        DATA_LIST.removeAll(arrayList);
        if (Main.getPlugin().isEnabled()) {
            MenuDataManager.removeData(uUID);
        }
    }

    public static void loadData(PlayerData playerData, int n) {
        try {
            UUID uUID = playerData.getPlayerId();
            SQLConnection sQLConnection = Plugin.getSQLConnection();
            if (sQLConnection != null && sQLConnection.isConnected()) {
                SQLSync sQLSync = new SQLSync(uUID);
                sQLSync.loadDataAsync(n);
                return;
            }
            FileSync fileSync = new FileSync(uUID);
            fileSync.loadDataAsync();
        }
        catch (Exception exception) {
            PlayerDataManager.logException(exception);
        }
    }

    public static void saveData(PlayerData playerData, boolean bl, boolean bl2) {
        try {
            Object object;
            UUID uUID = playerData.getPlayerId();
            SQLConnection sQLConnection = Plugin.getSQLConnection();
            if (sQLConnection != null && sQLConnection.isConnected()) {
                object = new SQLSync(uUID);
                if (bl) {
                    ((SQLSync)object).saveDataAsync();
                } else {
                    ((SQLSync)object).saveData();
                }
            }
            object = new FileSync(uUID);
            if (bl) {
                ((FileSync)object).saveDataAsync(bl2);
            } else {
                ((FileSync)object).saveData(bl2);
            }
        }
        catch (Exception exception) {
            PlayerDataManager.logException(exception);
        }
    }

    private static void logException(Exception exception) {
        Main.getPlugin().getLogger().warning("The data manager system failed.");
        exception.printStackTrace();
    }
}

