/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.playerdata.sync.files;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxManager;
import com.xericker.mysteryboxes.handlers.data.loots.Loot;
import com.xericker.mysteryboxes.handlers.data.loots.LootManager;
import com.xericker.mysteryboxes.handlers.data.loots.LootStatus;
import com.xericker.mysteryboxes.handlers.data.songs.SongData;
import com.xericker.mysteryboxes.handlers.data.songs.SongManager;
import com.xericker.mysteryboxes.handlers.data.themes.Theme;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeData;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeManager;
import com.xericker.mysteryboxes.handlers.data.upgrades.Upgrade;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeData;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeManager;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeStatus;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import com.xericker.mysteryboxes.playerdata.stats.Statistic;
import com.xericker.mysteryboxes.playerdata.stats.Timestamp;
import com.xericker.mysteryboxes.playerdata.sync.DataType;
import com.xericker.mysteryboxes.playerdata.sync.files.FileUtils;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FileSync {
    private UUID playerId;

    public UUID getPlayerId() {
        return this.playerId;
    }

    public FileSync(UUID uUID) {
        this.playerId = uUID;
    }

    public void loadDataAsync() {
        this.loadDataAsync(0);
    }

    public void loadDataAsync(int n) {
        new BukkitRunnable(){

            public void run() {
                FileSync.this.loadData();
            }
        }.runTaskLaterAsynchronously((Plugin)Main.getPlugin(), (long)n);
    }

    public void loadData() {
        try {
            int n;
            int n2;
            PlayerData playerData = PlayerDataManager.getData(this.playerId);
            playerData.setDataSynced(false);
            for (Box object2 : BoxManager.getList()) {
                n2 = FileUtils.getBoxes(this.playerId, object2);
                playerData.getBoxes().put(object2, n2);
            }
            for (Box box : BoxManager.getList()) {
                n2 = FileUtils.getGiftPacks(this.playerId, box);
                playerData.getGifts().put(box, n2);
            }
            playerData.setDust(FileUtils.getDust(this.playerId));
            FileConfiguration fileConfiguration = DataType.LOOTS.getFile(this.playerId);
            if (fileConfiguration != null) {
                for (String string : fileConfiguration.getKeys(false)) {
                    Loot loot = LootManager.getLoot(string);
                    if (loot == null || loot.getStatus() != LootStatus.ENABLED) continue;
                    playerData.getLootDiscovered().add(loot);
                }
            }
            for (Theme theme : Theme.values()) {
                long l;
                Object object = FileUtils.getObject(this.playerId, DataType.THEMES, theme.name());
                if (object == null || (l = Long.parseLong(object.toString())) == 0L) continue;
                playerData.getThemesUnlocked().put(theme, l);
            }
            Object object = FileUtils.getObject(this.playerId, DataType.MISC, "CHOSEN_THEME");
            String string = (String)object;
            Theme theme = null;
            if (ThemeManager.validateTheme(string)) {
                theme = Theme.valueOf(string);
            }
            if (ThemeManager.validateTheme(this.playerId, theme)) {
                playerData.setChosenTheme(theme);
            }
            for (SongData songData : SongManager.getList()) {
                long l;
                Object object2 = FileUtils.getObject(this.playerId, DataType.SONGS, songData.getSongId());
                if (object2 == null || (l = Long.parseLong(object2.toString())) == 0L) continue;
                playerData.getSongsUnlocked().put(songData.getSongId(), l);
            }
            FileUtils.readHistory(playerData);
            Upgrade[] upgradeArray = Upgrade.values();
            int n3 = upgradeArray.length;
            for (n = 0; n < n3; ++n) {
                Object object3;
                Upgrade upgrade = upgradeArray[n];
                UpgradeData upgradeData = UpgradeManager.getData(upgrade);
                if (upgradeData == null || upgradeData.getStatus() != UpgradeStatus.ENABLED || (object3 = FileUtils.getObject(this.playerId, DataType.UPGRADES, upgrade.name())) == null) continue;
                int n4 = 0;
                int n5 = upgradeData.getInterface().getMaxLevel();
                int n6 = (Integer)object3;
                if (n6 < n4) {
                    n6 = n4;
                }
                if (n6 > n5) {
                    n6 = n5;
                }
                playerData.setUpgrade(upgrade, n6);
            }
            Statistic[] statisticArray = Statistic.values();
            int n7 = statisticArray.length;
            for (n = 0; n < n7; ++n) {
                Statistic statistic = statisticArray[n];
                long l = FileUtils.getStatistic(this.playerId, statistic);
                if (l == 0L) continue;
                playerData.getStatistics().put(statistic, l);
            }
            for (Timestamp timestamp : Timestamp.values()) {
                long l = FileUtils.getTimestamp(this.playerId, timestamp);
                if (l == 0L) continue;
                playerData.getTimestamps().put(timestamp, l);
            }
            playerData.setDataSynced(true);
        }
        catch (Exception exception) {
            Main.getPlugin().getLogger().warning("An unexpected error has occurred!");
            Main.getPlugin().getLogger().warning("Send this error to the developer:");
            exception.printStackTrace();
        }
    }

    public void saveDataAsync(final boolean bl) {
        new BukkitRunnable(){

            public void run() {
                FileSync.this.saveData(bl);
            }
        }.runTaskAsynchronously((Plugin)Main.getPlugin());
    }

    public void saveData(boolean bl) {
        try {
            String string;
            PlayerData playerData = PlayerDataManager.getData(this.playerId);
            playerData.setDataSynced(false);
            for (Box object : playerData.getBoxes().keySet()) {
                FileUtils.setBoxes(this.playerId, object, playerData.getBoxes(object));
            }
            for (Box box : playerData.getGifts().keySet()) {
                FileUtils.setGiftPacks(this.playerId, box, playerData.getGifts(box));
            }
            FileUtils.setDust(this.playerId, playerData.getDust());
            for (Loot loot : playerData.getLootDiscovered()) {
                if (FileUtils.getObject(this.playerId, DataType.LOOTS, loot.getId()) != null) continue;
                FileUtils.setObject(this.playerId, DataType.LOOTS, loot.getId(), System.currentTimeMillis());
            }
            for (ThemeData themeData : ThemeManager.getList()) {
                string = themeData.getTheme().name();
                FileUtils.setObject(this.playerId, DataType.THEMES, string, playerData.getThemesUnlocked().get((Object)themeData.getTheme()));
            }
            FileUtils.setObject(this.playerId, DataType.MISC, "CHOSEN_THEME", playerData.getChosenTheme() != null ? playerData.getChosenTheme().name() : null);
            for (SongData songData : SongManager.getList()) {
                string = songData.getSongId();
                FileUtils.setObject(this.playerId, DataType.SONGS, string, playerData.getSongsUnlocked().get(string));
            }
            FileUtils.writeHistory(playerData);
            for (Iterator<Object> iterator : Upgrade.values()) {
                UpgradeData upgradeData = UpgradeManager.getData(iterator);
                if (upgradeData == null || upgradeData.getStatus() != UpgradeStatus.ENABLED) continue;
                FileUtils.setObject(this.playerId, DataType.UPGRADES, ((Enum)((Object)iterator)).name(), playerData.getUpgrade((Upgrade)((Object)iterator)));
            }
            for (Iterator<Object> iterator : Statistic.values()) {
                FileUtils.setStatistic(this.playerId, iterator, playerData.getStatistic((Statistic)((Object)iterator)));
            }
            for (Iterator<Object> iterator : Timestamp.values()) {
                FileUtils.setTimestamp(this.playerId, iterator, playerData.getTimestamp((Timestamp)((Object)iterator)));
            }
            playerData.setDataSynced(true);
            if (bl) {
                PlayerDataManager.removeData(playerData.getPlayerId());
            }
        }
        catch (Exception exception) {
            Main.getPlugin().getLogger().warning("An unexpected error has occurred!");
            Main.getPlugin().getLogger().warning("Send this error to the developer:");
            exception.printStackTrace();
        }
    }
}

