/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.playerdata.sync.sql;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.Plugin;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxManager;
import com.xericker.mysteryboxes.handlers.data.loots.Loot;
import com.xericker.mysteryboxes.handlers.data.loots.LootManager;
import com.xericker.mysteryboxes.handlers.data.loots.LootStatus;
import com.xericker.mysteryboxes.handlers.data.songs.SongData;
import com.xericker.mysteryboxes.handlers.data.songs.SongManager;
import com.xericker.mysteryboxes.handlers.data.themes.Theme;
import com.xericker.mysteryboxes.handlers.data.themes.ThemeManager;
import com.xericker.mysteryboxes.handlers.data.upgrades.Upgrade;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeData;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeManager;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeStatus;
import com.xericker.mysteryboxes.mysql.SQLConnection;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import com.xericker.mysteryboxes.playerdata.stats.Statistic;
import com.xericker.mysteryboxes.playerdata.stats.Timestamp;
import com.xericker.mysteryboxes.playerdata.sync.DataType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.scheduler.BukkitRunnable;
import utils.PluginUtils;

public class SQLSync {
    private UUID playerId;
    private PlayerData playerData;
    private SQLConnection sqlConnection;

    public SQLSync(UUID uUID) {
        this.playerId = uUID;
        this.sqlConnection = Plugin.getSQLConnection();
    }

    public void loadDataAsync(int n) {
        new BukkitRunnable(){

            public void run() {
                SQLSync.this.loadData();
            }
        }.runTaskLaterAsynchronously((org.bukkit.plugin.Plugin)Main.getPlugin(), (long)n);
    }

    public void loadData() {
        if (this.sqlConnection == null || !this.sqlConnection.isConnected()) {
            Main.getPlugin().getLogger().warning("Failed to load data (Connection is either null or not connected).");
            return;
        }
        this.createTables();
        this.playerData = PlayerDataManager.getData(this.playerId);
        this.playerData.setDataSynced(false);
        ArrayList<CompletableFuture<Void>> arrayList = new ArrayList<CompletableFuture<Void>>();
        arrayList.add(CompletableFuture.runAsync(this::loadBoxes));
        arrayList.add(CompletableFuture.runAsync(this::loadGifts));
        arrayList.add(CompletableFuture.runAsync(this::loadDust));
        arrayList.add(CompletableFuture.runAsync(this::loadThemesUnlocked));
        arrayList.add(CompletableFuture.runAsync(this::loadChosenTheme));
        arrayList.add(CompletableFuture.runAsync(this::loadSongsUnlocked));
        arrayList.add(CompletableFuture.runAsync(this::loadUpgrades));
        arrayList.add(CompletableFuture.runAsync(this::loadLootsDiscovered));
        arrayList.add(CompletableFuture.runAsync(this::loadLootHistory));
        arrayList.add(CompletableFuture.runAsync(this::loadStatistics));
        arrayList.add(CompletableFuture.runAsync(this::loadTimestamps));
        ((CompletableFuture)CompletableFuture.allOf(arrayList.toArray(new CompletableFuture[0])).thenRun(() -> this.playerData.setDataSynced(true))).exceptionally(throwable -> {
            Main.getPlugin().getLogger().warning("Failed to load data (CompletableFuture.allOf()).");
            throwable.printStackTrace();
            return null;
        });
    }

    public void saveDataAsync() {
        new BukkitRunnable(){

            public void run() {
                SQLSync.this.saveData();
            }
        }.runTaskAsynchronously((org.bukkit.plugin.Plugin)Main.getPlugin());
    }

    public void saveData() {
        if (this.sqlConnection == null || !this.sqlConnection.isConnected()) {
            Main.getPlugin().getLogger().warning("Failed to save data (Connection is either null or not connected).");
            return;
        }
        this.createTables();
        this.playerData = PlayerDataManager.getData(this.playerId);
        ArrayList<CompletableFuture<Void>> arrayList = new ArrayList<CompletableFuture<Void>>();
        arrayList.add(CompletableFuture.runAsync(this::saveBoxes));
        arrayList.add(CompletableFuture.runAsync(this::saveGifts));
        arrayList.add(CompletableFuture.runAsync(this::saveDust));
        arrayList.add(CompletableFuture.runAsync(this::saveThemesUnlocked));
        arrayList.add(CompletableFuture.runAsync(this::saveChosenTheme));
        arrayList.add(CompletableFuture.runAsync(this::saveSongsUnlocked));
        arrayList.add(CompletableFuture.runAsync(this::saveUpgrades));
        arrayList.add(CompletableFuture.runAsync(this::saveLootsDiscovered));
        arrayList.add(CompletableFuture.runAsync(this::saveLootHistory));
        arrayList.add(CompletableFuture.runAsync(this::saveStatistics));
        arrayList.add(CompletableFuture.runAsync(this::saveTimestamps));
        CompletableFuture.allOf(arrayList.toArray(new CompletableFuture[0])).exceptionally(throwable -> {
            Main.getPlugin().getLogger().warning("Failed to save data (CompletableFuture.allOf()).");
            throwable.printStackTrace();
            return null;
        });
    }

    private void createTables() {
        if (this.sqlConnection == null || !this.sqlConnection.isConnected()) {
            Main.getPlugin().getLogger().warning("Failed to create tables (Connection is either null or not connected).");
            return;
        }
        for (DataType dataType : DataType.values()) {
            if (dataType == DataType.PLAYERS) continue;
            String string = "CREATE TABLE IF NOT EXISTS " + dataType.getTable() + " (PLAYER_ID CHAR(36));";
            this.sqlConnection.update(string);
        }
    }

    private void loadBoxes() {
        try {
            for (Box box : BoxManager.getList()) {
                ResultSet resultSet;
                Object object = box.getId().replace("-", "_");
                if (PluginUtils.isInteger((String)object)) {
                    object = "_" + (String)object;
                }
                if (this.sqlConnection.isColumnMissing(DataType.BOXES.getTable(), (String)object)) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.BOXES.getTable() + " ADD " + (String)object + " INT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + (String)object + " FROM " + DataType.BOXES.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) == null || !resultSet.next()) continue;
                this.playerData.setBoxes(box, resultSet.getInt((String)object));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void loadGifts() {
        try {
            for (Box box : BoxManager.getList()) {
                ResultSet resultSet;
                Object object = box.getId().replace("-", "_");
                if (PluginUtils.isInteger((String)object)) {
                    object = "_" + (String)object;
                }
                if (this.sqlConnection.isColumnMissing(DataType.GIFTS.getTable(), (String)object)) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.GIFTS.getTable() + " ADD " + (String)object + " INT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + (String)object + " FROM " + DataType.GIFTS.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) == null || !resultSet.next()) continue;
                this.playerData.setGifts(box, resultSet.getInt((String)object));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void loadDust() {
        try {
            ResultSet resultSet;
            if (this.sqlConnection.isColumnMissing(DataType.DUST.getTable(), "MYSTERY_DUST")) {
                this.sqlConnection.update("ALTER TABLE " + DataType.DUST.getTable() + " ADD MYSTERY_DUST INT;");
            }
            if ((resultSet = this.sqlConnection.query("SELECT MYSTERY_DUST FROM " + DataType.DUST.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) != null && resultSet.next()) {
                this.playerData.setDust(resultSet.getInt("MYSTERY_DUST"));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void loadLootsDiscovered() {
        try {
            for (Loot loot : LootManager.getList()) {
                ResultSet resultSet;
                if (loot.getStatus() != LootStatus.ENABLED) continue;
                Object object = loot.getId().replace("-", "_");
                if (PluginUtils.isInteger((String)object)) {
                    object = "_" + (String)object;
                }
                if (this.sqlConnection.isColumnMissing(DataType.LOOTS.getTable(), (String)object)) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.LOOTS.getTable() + " ADD " + (String)object + " BIGINT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + (String)object + " FROM " + DataType.LOOTS.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) == null || !resultSet.next()) continue;
                this.playerData.getLootDiscovered().add(loot);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void loadThemesUnlocked() {
        try {
            for (Theme theme : Theme.values()) {
                long l;
                ResultSet resultSet;
                if (this.sqlConnection.isColumnMissing(DataType.THEMES.getTable(), theme.name())) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.THEMES.getTable() + " ADD " + theme.name() + " BIGINT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + theme.name() + " FROM " + DataType.THEMES.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) == null || !resultSet.next() || (l = resultSet.getLong(theme.name())) == 0L) continue;
                this.playerData.getThemesUnlocked().put(theme, l);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void loadChosenTheme() {
        try {
            ResultSet resultSet;
            if (this.sqlConnection.isColumnMissing(DataType.MISC.getTable(), "CHOSEN_THEME")) {
                this.sqlConnection.update("ALTER TABLE " + DataType.MISC.getTable() + " ADD CHOSEN_THEME VARCHAR(255);");
            }
            if ((resultSet = this.sqlConnection.query("SELECT CHOSEN_THEME FROM " + DataType.MISC.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) != null && resultSet.next()) {
                String string = resultSet.getString("CHOSEN_THEME");
                Theme theme = null;
                if (ThemeManager.validateTheme(string)) {
                    theme = Theme.valueOf(string);
                }
                if (ThemeManager.validateTheme(this.playerId, theme)) {
                    this.playerData.setChosenTheme(theme);
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void loadSongsUnlocked() {
        try {
            for (SongData songData : SongManager.getList()) {
                long l;
                ResultSet resultSet;
                Object object = songData.getSongId().replace("-", "_");
                if (PluginUtils.isInteger((String)object)) {
                    object = "_" + (String)object;
                }
                if (this.sqlConnection.isColumnMissing(DataType.SONGS.getTable(), (String)object)) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.SONGS.getTable() + " ADD " + (String)object + " BIGINT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + (String)object + " FROM " + DataType.SONGS.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) == null || !resultSet.next() || (l = resultSet.getLong((String)object)) == 0L) continue;
                this.playerData.getSongsUnlocked().put(songData.getSongId(), l);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void loadLootHistory() {
    }

    private void loadUpgrades() {
        try {
            for (Upgrade upgrade : Upgrade.values()) {
                ResultSet resultSet;
                UpgradeData upgradeData = UpgradeManager.getData(upgrade);
                if (upgradeData == null || upgradeData.getStatus() != UpgradeStatus.ENABLED) continue;
                if (this.sqlConnection.isColumnMissing(DataType.UPGRADES.getTable(), upgrade.name())) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.UPGRADES.getTable() + " ADD " + upgrade.name() + " INT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + upgrade.name() + " FROM " + DataType.UPGRADES.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) == null || !resultSet.next()) continue;
                int n = 0;
                int n2 = upgradeData.getInterface().getMaxLevel();
                int n3 = resultSet.getInt(upgrade.name());
                if (n3 < n) {
                    n3 = n;
                }
                if (n3 > n2) {
                    n3 = n2;
                }
                this.playerData.setUpgrade(upgrade, n3);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void loadStatistics() {
        try {
            for (Statistic statistic : Statistic.values()) {
                ResultSet resultSet;
                if (this.sqlConnection.isColumnMissing(DataType.STATS.getTable(), statistic.name())) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.STATS.getTable() + " ADD " + statistic.name() + " BIGINT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + statistic.name() + " FROM " + DataType.STATS.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) == null || !resultSet.next()) continue;
                this.playerData.setStatistic(statistic, resultSet.getLong(statistic.name()));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void loadTimestamps() {
        try {
            for (Timestamp timestamp : Timestamp.values()) {
                ResultSet resultSet;
                if (this.sqlConnection.isColumnMissing(DataType.TIMES.getTable(), timestamp.name())) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.TIMES.getTable() + " ADD " + timestamp.name() + " BIGINT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + timestamp.name() + " FROM " + DataType.TIMES.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) == null || !resultSet.next()) continue;
                this.playerData.setTimestamp(timestamp, resultSet.getLong(timestamp.name()));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void saveBoxes() {
        try {
            for (Box box : this.playerData.getBoxes().keySet()) {
                ResultSet resultSet;
                Object object = box.getId().replace("-", "_");
                if (PluginUtils.isInteger((String)object)) {
                    object = "_" + (String)object;
                }
                if (this.sqlConnection.isColumnMissing(DataType.BOXES.getTable(), (String)object)) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.BOXES.getTable() + " ADD " + (String)object + " INT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + (String)object + " FROM " + DataType.BOXES.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) != null && !resultSet.next()) {
                    this.sqlConnection.update("INSERT INTO " + DataType.BOXES.getTable() + "(PLAYER_ID, " + (String)object + ") VALUES ('" + String.valueOf(this.playerId) + "', " + this.playerData.getBoxes(box) + ");");
                    continue;
                }
                this.sqlConnection.update("UPDATE " + DataType.BOXES.getTable() + " SET " + (String)object + "=" + this.playerData.getBoxes(box) + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void saveGifts() {
        try {
            for (Box box : this.playerData.getGifts().keySet()) {
                ResultSet resultSet;
                Object object = box.getId().replace("-", "_");
                if (PluginUtils.isInteger((String)object)) {
                    object = "_" + (String)object;
                }
                if (this.sqlConnection.isColumnMissing(DataType.GIFTS.getTable(), (String)object)) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.GIFTS.getTable() + " ADD " + (String)object + " INT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + (String)object + " FROM " + DataType.GIFTS.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) != null && !resultSet.next()) {
                    this.sqlConnection.update("INSERT INTO " + DataType.GIFTS.getTable() + "(PLAYER_ID, " + (String)object + ") VALUES ('" + String.valueOf(this.playerId) + "', " + this.playerData.getGifts(box) + ");");
                    continue;
                }
                this.sqlConnection.update("UPDATE " + DataType.GIFTS.getTable() + " SET " + (String)object + "=" + this.playerData.getGifts(box) + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void saveDust() {
        try {
            ResultSet resultSet;
            if (this.sqlConnection.isColumnMissing(DataType.DUST.getTable(), "MYSTERY_DUST")) {
                this.sqlConnection.update("ALTER TABLE " + DataType.DUST.getTable() + " ADD MYSTERY_DUST INT;");
            }
            if ((resultSet = this.sqlConnection.query("SELECT MYSTERY_DUST FROM " + DataType.DUST.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) != null && resultSet.next()) {
                this.sqlConnection.update("UPDATE " + DataType.DUST.getTable() + " SET MYSTERY_DUST=" + this.playerData.getDust() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';");
            } else {
                this.sqlConnection.update("INSERT INTO " + DataType.DUST.getTable() + "(PLAYER_ID, MYSTERY_DUST) VALUES ('" + String.valueOf(this.playerId) + "', " + this.playerData.getDust() + ");");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void saveLootsDiscovered() {
        try {
            for (Loot loot : this.playerData.getLootDiscovered()) {
                ResultSet resultSet;
                if (loot.getStatus() != LootStatus.ENABLED) continue;
                Object object = loot.getId().replace("-", "_");
                if (PluginUtils.isInteger((String)object)) {
                    object = "_" + (String)object;
                }
                if (this.sqlConnection.isColumnMissing(DataType.LOOTS.getTable(), (String)object)) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.LOOTS.getTable() + " ADD " + (String)object + " BIGINT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + (String)object + " FROM " + DataType.LOOTS.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) == null || resultSet.next()) continue;
                this.sqlConnection.update("INSERT INTO " + DataType.LOOTS.getTable() + "(PLAYER_ID, " + (String)object + ") VALUES ('" + String.valueOf(this.playerId) + "', " + System.currentTimeMillis() + ");");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void saveThemesUnlocked() {
        try {
            for (Theme theme : Theme.values()) {
                ResultSet resultSet;
                if (this.sqlConnection.isColumnMissing(DataType.THEMES.getTable(), theme.name())) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.THEMES.getTable() + " ADD " + theme.name() + " BIGINT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + theme.name() + " FROM " + DataType.THEMES.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) != null && !resultSet.next()) {
                    this.sqlConnection.update("INSERT INTO " + DataType.THEMES.getTable() + "(PLAYER_ID, " + theme.name() + ") VALUES ('" + String.valueOf(this.playerId) + "', " + String.valueOf(this.playerData.getThemesUnlocked().getOrDefault((Object)theme, 0L)) + ");");
                    continue;
                }
                this.sqlConnection.update("UPDATE " + DataType.THEMES.getTable() + " SET " + theme.name() + "=" + String.valueOf(this.playerData.getThemesUnlocked().get((Object)theme)) + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void saveChosenTheme() {
        try {
            String string;
            if (this.sqlConnection.isColumnMissing(DataType.MISC.getTable(), "CHOSEN_THEME")) {
                this.sqlConnection.update("ALTER TABLE " + DataType.MISC.getTable() + " ADD CHOSEN_THEME VARCHAR(255);");
            }
            ResultSet resultSet = this.sqlConnection.query("SELECT CHOSEN_THEME FROM " + DataType.MISC.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';");
            Theme theme = this.playerData.getChosenTheme();
            String string2 = string = theme == null ? null : theme.name();
            if (resultSet != null && resultSet.next()) {
                this.sqlConnection.update("UPDATE " + DataType.MISC.getTable() + " SET CHOSEN_THEME='" + string + "' WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';");
            } else {
                this.sqlConnection.update("INSERT INTO " + DataType.MISC.getTable() + "(PLAYER_ID, CHOSEN_THEME) VALUES ('" + String.valueOf(this.playerId) + "', '" + string + "');");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void saveSongsUnlocked() {
        try {
            for (SongData songData : SongManager.getList()) {
                ResultSet resultSet;
                Object object = songData.getSongId().replace("-", "_");
                if (PluginUtils.isInteger((String)object)) {
                    object = "_" + (String)object;
                }
                if (this.sqlConnection.isColumnMissing(DataType.SONGS.getTable(), (String)object)) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.SONGS.getTable() + " ADD " + (String)object + " BIGINT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + (String)object + " FROM " + DataType.SONGS.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) != null && !resultSet.next()) {
                    this.sqlConnection.update("INSERT INTO " + DataType.SONGS.getTable() + "(PLAYER_ID, " + (String)object + ") VALUES ('" + String.valueOf(this.playerId) + "', " + String.valueOf(this.playerData.getSongsUnlocked().getOrDefault(songData.getSongId(), 0L)) + ");");
                    continue;
                }
                this.sqlConnection.update("UPDATE " + DataType.SONGS.getTable() + " SET " + (String)object + "=" + String.valueOf(this.playerData.getSongsUnlocked().get(songData.getSongId())) + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void saveLootHistory() {
    }

    private void saveUpgrades() {
        try {
            for (Upgrade upgrade : Upgrade.values()) {
                ResultSet resultSet;
                UpgradeData upgradeData = UpgradeManager.getData(upgrade);
                if (upgradeData == null || upgradeData.getStatus() != UpgradeStatus.ENABLED) continue;
                if (this.sqlConnection.isColumnMissing(DataType.UPGRADES.getTable(), upgrade.name())) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.UPGRADES.getTable() + " ADD " + upgrade.name() + " INT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + upgrade.name() + " FROM " + DataType.UPGRADES.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) != null && resultSet.next()) {
                    this.sqlConnection.update("UPDATE " + DataType.UPGRADES.getTable() + " SET " + upgrade.name() + "=" + this.playerData.getUpgrade(upgrade) + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';");
                    continue;
                }
                this.sqlConnection.update("INSERT INTO " + DataType.UPGRADES.getTable() + "(PLAYER_ID, " + upgrade.name() + ") VALUES ('" + String.valueOf(this.playerId) + "', " + this.playerData.getUpgrade(upgrade) + ");");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void saveStatistics() {
        try {
            for (Statistic statistic : Statistic.values()) {
                ResultSet resultSet;
                if (this.sqlConnection.isColumnMissing(DataType.STATS.getTable(), statistic.name())) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.STATS.getTable() + " ADD " + statistic.name() + " BIGINT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + statistic.name() + " FROM " + DataType.STATS.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) != null && !resultSet.next()) {
                    this.sqlConnection.update("INSERT INTO " + DataType.STATS.getTable() + "(PLAYER_ID, " + statistic.name() + ") VALUES ('" + String.valueOf(this.playerId) + "', " + this.playerData.getStatistic(statistic) + ");");
                    continue;
                }
                this.sqlConnection.update("UPDATE " + DataType.STATS.getTable() + " SET " + statistic.name() + "=" + this.playerData.getStatistic(statistic) + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void saveTimestamps() {
        try {
            for (Timestamp timestamp : Timestamp.values()) {
                ResultSet resultSet;
                if (this.sqlConnection.isColumnMissing(DataType.TIMES.getTable(), timestamp.name())) {
                    this.sqlConnection.update("ALTER TABLE " + DataType.TIMES.getTable() + " ADD " + timestamp.name() + " BIGINT;");
                }
                if ((resultSet = this.sqlConnection.query("SELECT " + timestamp.name() + " FROM " + DataType.TIMES.getTable() + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';")) != null && !resultSet.next()) {
                    this.sqlConnection.update("INSERT INTO " + DataType.TIMES.getTable() + "(PLAYER_ID, " + timestamp.name() + ") VALUES ('" + String.valueOf(this.playerId) + "', " + this.playerData.getTimestamp(timestamp) + ");");
                    continue;
                }
                this.sqlConnection.update("UPDATE " + DataType.TIMES.getTable() + " SET " + timestamp.name() + "=" + this.playerData.getTimestamp(timestamp) + " WHERE PLAYER_ID='" + String.valueOf(this.playerId) + "';");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

