/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.analysis;

import java.io.PrintStream;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.InstructionPrinter;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.analysis.Analyzer;
import javassist.bytecode.analysis.Frame;
import javassist.bytecode.analysis.Type;

public final class FramePrinter {
    private final PrintStream stream;

    public FramePrinter(PrintStream printStream) {
        this.stream = printStream;
    }

    public static void print(CtClass ctClass, PrintStream printStream) {
        new FramePrinter(printStream).print(ctClass);
    }

    public void print(CtClass ctClass) {
        CtMethod[] ctMethodArray = ctClass.getDeclaredMethods();
        for (int i = 0; i < ctMethodArray.length; ++i) {
            this.print(ctMethodArray[i]);
        }
    }

    private String getMethodString(CtMethod ctMethod) {
        try {
            return Modifier.toString(ctMethod.getModifiers()) + " " + ctMethod.getReturnType().getName() + " " + ctMethod.getName() + Descriptor.toString(ctMethod.getSignature()) + ";";
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
    }

    public void print(CtMethod ctMethod) {
        Frame[] frameArray;
        this.stream.println("\n" + this.getMethodString(ctMethod));
        MethodInfo methodInfo = ctMethod.getMethodInfo2();
        ConstPool constPool = methodInfo.getConstPool();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            return;
        }
        try {
            frameArray = new Analyzer().analyze(ctMethod.getDeclaringClass(), methodInfo);
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
        int n = String.valueOf(codeAttribute.getCodeLength()).length();
        CodeIterator codeIterator = codeAttribute.iterator();
        while (codeIterator.hasNext()) {
            int n2;
            try {
                n2 = codeIterator.next();
            }
            catch (BadBytecode badBytecode) {
                throw new RuntimeException(badBytecode);
            }
            this.stream.println(n2 + ": " + InstructionPrinter.instructionString(codeIterator, n2, constPool));
            this.addSpacing(n + 3);
            Frame frame = frameArray[n2];
            if (frame == null) {
                this.stream.println("--DEAD CODE--");
                continue;
            }
            this.printStack(frame);
            this.addSpacing(n + 3);
            this.printLocals(frame);
        }
    }

    private void printStack(Frame frame) {
        this.stream.print("stack [");
        int n = frame.getTopIndex();
        for (int i = 0; i <= n; ++i) {
            if (i > 0) {
                this.stream.print(", ");
            }
            Type type = frame.getStack(i);
            this.stream.print(type);
        }
        this.stream.println("]");
    }

    private void printLocals(Frame frame) {
        this.stream.print("locals [");
        int n = frame.localsLength();
        for (int i = 0; i < n; ++i) {
            Type type;
            if (i > 0) {
                this.stream.print(", ");
            }
            this.stream.print((type = frame.getLocal(i)) == null ? "empty" : type.toString());
        }
        this.stream.println("]");
    }

    private void addSpacing(int n) {
        while (n-- > 0) {
            this.stream.print(' ');
        }
    }
}

