/*
 * Decompiled with CFR 0.152.
 */
package misc;

import com.xericker.mysteryboxes.compiled.NBTItem;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemNBT {
    private ItemNBT() {
        throw new IllegalStateException("Utility class");
    }

    public static ItemStack add(ItemStack itemStack, String string, String string2) {
        if (!ItemNBT.validate(itemStack)) {
            return itemStack;
        }
        NBTItem nBTItem = new NBTItem(itemStack);
        nBTItem.setString(string2, string);
        nBTItem.applyNBT(itemStack);
        return itemStack;
    }

    public static ItemStack add(ItemStack itemStack, List<String> list) {
        if (!ItemNBT.validate(itemStack)) {
            return itemStack;
        }
        for (String string : list) {
            String[] stringArray = string.split(";");
            if (stringArray.length == 0) continue;
            if (stringArray.length == 1) {
                ItemNBT.add(itemStack, Boolean.TRUE.toString(), stringArray[0]);
                continue;
            }
            ItemNBT.add(itemStack, stringArray[1], stringArray[0]);
        }
        return itemStack;
    }

    private static boolean validate(ItemStack itemStack) {
        return itemStack != null && itemStack.getType() != Material.AIR && itemStack.getAmount() > 0;
    }

    public static boolean contains(ItemStack itemStack, String string) {
        return ItemNBT.validate(itemStack) && new NBTItem(itemStack).hasTag(string);
    }

    public static NBTItem get(ItemStack itemStack) {
        if (!ItemNBT.validate(itemStack)) {
            return null;
        }
        return new NBTItem(itemStack);
    }

    public static String getString(ItemStack itemStack, String string) {
        if (!ItemNBT.validate(itemStack)) {
            return null;
        }
        NBTItem nBTItem = new NBTItem(itemStack);
        return nBTItem.getString(string);
    }
}

