/*
 * Decompiled with CFR 0.152.
 */
package misc;

public class KFormatter {
    private boolean kFormat;

    public KFormatter(boolean bl) {
        this.kFormat = bl;
    }

    public String toK(int n) {
        return this.toK((long)n);
    }

    public String toK(long l) {
        if (!this.kFormat || l < 1000L) {
            return String.valueOf(l);
        }
        int n = (int)(Math.log(l) / Math.log(1000.0));
        char c = "kMGTPE".charAt(n - 1);
        double d = Math.pow(1000.0, n);
        String string = String.format("%.1f%c", (double)l / d, Character.valueOf(c));
        return string.replaceAll("\\.0", "");
    }

    public String toRoman(int n) {
        if (n == 0) {
            return "0";
        }
        if (n < 0) {
            return "?";
        }
        int[] nArray = new int[]{1000, 900, 500, 100, 90, 50, 10, 9, 5, 1};
        String[] stringArray = new String[]{"M", "CM", "D", "C", "XC", "L", "X", "IX", "V", "I"};
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = n / nArray[i];
            if (n2 == 0) continue;
            if (n2 == 4 && i > 0) {
                stringBuilder.append(stringArray[i]).append(stringArray[i - 1]);
            } else {
                stringBuilder.append(stringArray[i].repeat(n2));
            }
            n %= nArray[i];
        }
        return stringBuilder.toString();
    }
}

