/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.Utils;

public abstract class ReflectionUtils {
    public static boolean includeObject = false;
    private static List<String> primitiveNames;
    private static List<Class> primitiveTypes;
    private static List<String> primitiveDescriptors;

    public static Set<Class<?>> getAllSuperTypes(Class<?> clazz, Predicate<? super Class<?>> ... predicateArray) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        if (clazz != null && (includeObject || !clazz.equals(Object.class))) {
            linkedHashSet.add(clazz);
            for (Class<?> clazz2 : ReflectionUtils.getSuperTypes(clazz)) {
                linkedHashSet.addAll(ReflectionUtils.getAllSuperTypes(clazz2, new Predicate[0]));
            }
        }
        return Utils.filter(linkedHashSet, predicateArray);
    }

    public static Set<Class<?>> getSuperTypes(Class<?> clazz) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Class<?> clazz2 = clazz.getSuperclass();
        Class<?>[] classArray = clazz.getInterfaces();
        if (clazz2 != null && (includeObject || !clazz2.equals(Object.class))) {
            linkedHashSet.add(clazz2);
        }
        if (classArray != null && classArray.length > 0) {
            linkedHashSet.addAll(Arrays.asList(classArray));
        }
        return linkedHashSet;
    }

    public static Set<Method> getAllMethods(Class<?> clazz, Predicate<? super Method> ... predicateArray) {
        HashSet<Method> hashSet = new HashSet<Method>();
        for (Class<?> clazz2 : ReflectionUtils.getAllSuperTypes(clazz, new Predicate[0])) {
            hashSet.addAll(ReflectionUtils.getMethods(clazz2, predicateArray));
        }
        return hashSet;
    }

    public static Set<Method> getMethods(Class<?> clazz, Predicate<? super Method> ... predicateArray) {
        return Utils.filter(clazz.isInterface() ? clazz.getMethods() : clazz.getDeclaredMethods(), predicateArray);
    }

    public static Set<Constructor> getAllConstructors(Class<?> clazz, Predicate<? super Constructor> ... predicateArray) {
        HashSet<Constructor> hashSet = new HashSet<Constructor>();
        for (Class<?> clazz2 : ReflectionUtils.getAllSuperTypes(clazz, new Predicate[0])) {
            hashSet.addAll(ReflectionUtils.getConstructors(clazz2, predicateArray));
        }
        return hashSet;
    }

    public static Set<Constructor> getConstructors(Class<?> clazz, Predicate<? super Constructor> ... predicateArray) {
        return Utils.filter(clazz.getDeclaredConstructors(), predicateArray);
    }

    public static Set<Field> getAllFields(Class<?> clazz, Predicate<? super Field> ... predicateArray) {
        HashSet<Field> hashSet = new HashSet<Field>();
        for (Class<?> clazz2 : ReflectionUtils.getAllSuperTypes(clazz, new Predicate[0])) {
            hashSet.addAll(ReflectionUtils.getFields(clazz2, predicateArray));
        }
        return hashSet;
    }

    public static Set<Field> getFields(Class<?> clazz, Predicate<? super Field> ... predicateArray) {
        return Utils.filter(clazz.getDeclaredFields(), predicateArray);
    }

    public static <T extends AnnotatedElement> Set<Annotation> getAllAnnotations(T t, Predicate<Annotation> ... predicateArray) {
        HashSet<Annotation> hashSet = new HashSet<Annotation>();
        if (t instanceof Class) {
            for (Class<?> clazz : ReflectionUtils.getAllSuperTypes((Class)t, new Predicate[0])) {
                hashSet.addAll(ReflectionUtils.getAnnotations(clazz, predicateArray));
            }
        } else {
            hashSet.addAll(ReflectionUtils.getAnnotations(t, predicateArray));
        }
        return hashSet;
    }

    public static <T extends AnnotatedElement> Set<Annotation> getAnnotations(T t, Predicate<Annotation> ... predicateArray) {
        return Utils.filter(t.getDeclaredAnnotations(), predicateArray);
    }

    public static <T extends AnnotatedElement> Set<T> getAll(Set<T> set, Predicate<? super T> ... predicateArray) {
        return Utils.filter(set, predicateArray);
    }

    public static <T extends Member> Predicate<T> withName(String string) {
        return member -> member != null && member.getName().equals(string);
    }

    public static <T extends Member> Predicate<T> withPrefix(String string) {
        return member -> member != null && member.getName().startsWith(string);
    }

    public static <T extends AnnotatedElement> Predicate<T> withPattern(String string) {
        return annotatedElement -> Pattern.matches(string, annotatedElement.toString());
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotation(Class<? extends Annotation> clazz) {
        return annotatedElement -> annotatedElement != null && annotatedElement.isAnnotationPresent(clazz);
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotations(Class<? extends Annotation> ... classArray) {
        return annotatedElement -> annotatedElement != null && Arrays.equals(classArray, ReflectionUtils.annotationTypes(annotatedElement.getAnnotations()));
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotation(Annotation annotation) {
        return annotatedElement -> annotatedElement != null && annotatedElement.isAnnotationPresent(annotation.annotationType()) && ReflectionUtils.areAnnotationMembersMatching(annotatedElement.getAnnotation(annotation.annotationType()), annotation);
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotations(Annotation ... annotationArray) {
        return annotatedElement -> {
            Annotation[] annotationArray2;
            if (annotatedElement != null && (annotationArray2 = annotatedElement.getAnnotations()).length == annotationArray.length) {
                return IntStream.range(0, annotationArray2.length).allMatch(n -> ReflectionUtils.areAnnotationMembersMatching(annotationArray2[n], annotationArray[n]));
            }
            return true;
        };
    }

    public static Predicate<Member> withParameters(Class<?> ... classArray) {
        return member -> Arrays.equals(ReflectionUtils.parameterTypes(member), classArray);
    }

    public static Predicate<Member> withParametersAssignableTo(Class ... classArray) {
        return member -> ReflectionUtils.isAssignable(classArray, ReflectionUtils.parameterTypes(member));
    }

    public static Predicate<Member> withParametersAssignableFrom(Class ... classArray) {
        return member -> ReflectionUtils.isAssignable(ReflectionUtils.parameterTypes(member), classArray);
    }

    public static Predicate<Member> withParametersCount(int n) {
        return member -> member != null && ReflectionUtils.parameterTypes(member).length == n;
    }

    public static Predicate<Member> withAnyParameterAnnotation(Class<? extends Annotation> clazz) {
        return member -> member != null && ReflectionUtils.annotationTypes(ReflectionUtils.parameterAnnotations(member)).stream().anyMatch(clazz2 -> clazz2.equals(clazz));
    }

    public static Predicate<Member> withAnyParameterAnnotation(Annotation annotation) {
        return member -> member != null && ReflectionUtils.parameterAnnotations(member).stream().anyMatch(annotation2 -> ReflectionUtils.areAnnotationMembersMatching(annotation, annotation2));
    }

    public static <T> Predicate<Field> withType(Class<T> clazz) {
        return field -> field != null && field.getType().equals(clazz);
    }

    public static <T> Predicate<Field> withTypeAssignableTo(Class<T> clazz) {
        return field -> field != null && clazz.isAssignableFrom(field.getType());
    }

    public static <T> Predicate<Method> withReturnType(Class<T> clazz) {
        return method -> method != null && method.getReturnType().equals(clazz);
    }

    public static <T> Predicate<Method> withReturnTypeAssignableTo(Class<T> clazz) {
        return method -> method != null && clazz.isAssignableFrom(method.getReturnType());
    }

    public static <T extends Member> Predicate<T> withModifier(int n) {
        return member -> member != null && (member.getModifiers() & n) != 0;
    }

    public static Predicate<Class<?>> withClassModifier(int n) {
        return clazz -> clazz != null && (clazz.getModifiers() & n) != 0;
    }

    public static Class<?> forName(String string, ClassLoader ... classLoaderArray) {
        String string2;
        if (ReflectionUtils.getPrimitiveNames().contains(string)) {
            return ReflectionUtils.getPrimitiveTypes().get(ReflectionUtils.getPrimitiveNames().indexOf(string));
        }
        if (string.contains("[")) {
            int n = string.indexOf("[");
            string2 = string.substring(0, n);
            String string3 = string.substring(n).replace("]", "");
            string2 = ReflectionUtils.getPrimitiveNames().contains(string2) ? ReflectionUtils.getPrimitiveDescriptors().get(ReflectionUtils.getPrimitiveNames().indexOf(string2)) : "L" + string2 + ";";
            string2 = (String)string3 + string2;
        } else {
            string2 = string;
        }
        ArrayList<ReflectionsException> arrayList = new ArrayList<ReflectionsException>();
        for (ClassLoader classLoader : ClasspathHelper.classLoaders(classLoaderArray)) {
            if (string2.contains("[")) {
                try {
                    return Class.forName(string2, false, classLoader);
                }
                catch (Throwable throwable) {
                    arrayList.add(new ReflectionsException("could not get type for name " + string, throwable));
                }
            }
            try {
                return classLoader.loadClass(string2);
            }
            catch (Throwable throwable) {
                arrayList.add(new ReflectionsException("could not get type for name " + string, throwable));
            }
        }
        if (Reflections.log != null) {
            for (ReflectionsException reflectionsException : arrayList) {
                Reflections.log.warn("could not get type for name " + string + " from any class loader", (Throwable)reflectionsException);
            }
        }
        return null;
    }

    public static <T> Set<Class<? extends T>> forNames(Collection<String> collection, ClassLoader ... classLoaderArray) {
        return collection.stream().map(string -> ReflectionUtils.forName(string, classLoaderArray)).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static Class[] parameterTypes(Member member) {
        return member != null ? (member.getClass() == Method.class ? ((Method)member).getParameterTypes() : (member.getClass() == Constructor.class ? ((Constructor)member).getParameterTypes() : null)) : null;
    }

    private static Set<Annotation> parameterAnnotations(Member member) {
        Annotation[][] annotationArray = member instanceof Method ? ((Method)member).getParameterAnnotations() : (member instanceof Constructor ? ((Constructor)member).getParameterAnnotations() : (Annotation[][])null);
        return Arrays.stream(annotationArray).flatMap(Arrays::stream).collect(Collectors.toSet());
    }

    private static Set<Class<? extends Annotation>> annotationTypes(Collection<Annotation> collection) {
        return collection.stream().map(Annotation::annotationType).collect(Collectors.toSet());
    }

    private static Class<? extends Annotation>[] annotationTypes(Annotation[] annotationArray) {
        return (Class[])Arrays.stream(annotationArray).map(Annotation::annotationType).toArray(Class[]::new);
    }

    private static void initPrimitives() {
        if (primitiveNames == null) {
            primitiveNames = Arrays.asList("boolean", "char", "byte", "short", "int", "long", "float", "double", "void");
            primitiveTypes = Arrays.asList(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE);
            primitiveDescriptors = Arrays.asList("Z", "C", "B", "S", "I", "J", "F", "D", "V");
        }
    }

    private static List<String> getPrimitiveNames() {
        ReflectionUtils.initPrimitives();
        return primitiveNames;
    }

    private static List<Class> getPrimitiveTypes() {
        ReflectionUtils.initPrimitives();
        return primitiveTypes;
    }

    private static List<String> getPrimitiveDescriptors() {
        ReflectionUtils.initPrimitives();
        return primitiveDescriptors;
    }

    private static boolean areAnnotationMembersMatching(Annotation annotation, Annotation annotation2) {
        if (annotation2 != null && annotation.annotationType() == annotation2.annotationType()) {
            for (Method method : annotation.annotationType().getDeclaredMethods()) {
                try {
                    if (method.invoke((Object)annotation, new Object[0]).equals(method.invoke((Object)annotation2, new Object[0]))) continue;
                    return false;
                }
                catch (Exception exception) {
                    throw new ReflectionsException(String.format("could not invoke method %s on annotation %s", method.getName(), annotation.annotationType()), exception);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isAssignable(Class[] classArray, Class[] classArray2) {
        if (classArray == null) {
            return classArray2 == null || classArray2.length == 0;
        }
        if (classArray.length != classArray2.length) {
            return false;
        }
        return IntStream.range(0, classArray.length).noneMatch(n -> !classArray2[n].isAssignableFrom(classArray[n]) || classArray2[n] == Object.class && classArray[n] != Object.class);
    }
}

