/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.ReflectionsException;
import org.reflections.Store;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MemberUsageScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.MethodParameterNamesScanner;
import org.reflections.scanners.MethodParameterScanner;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.serializers.Serializer;
import org.reflections.serializers.XmlSerializer;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.reflections.util.Utils;
import org.reflections.vfs.Vfs;
import org.slf4j.Logger;

public class Reflections {
    public static Logger log = Utils.findLogger(Reflections.class);
    protected final transient Configuration configuration;
    protected Store store;

    public Reflections(Configuration configuration) {
        this.configuration = configuration;
        this.store = new Store();
        if (configuration.getScanners() != null && !configuration.getScanners().isEmpty()) {
            for (Scanner scanner : configuration.getScanners()) {
                scanner.setConfiguration(configuration);
            }
            this.scan();
            if (configuration.shouldExpandSuperTypes()) {
                this.expandSuperTypes();
            }
        }
    }

    public Reflections(String string, Scanner ... scannerArray) {
        this(new Object[]{string, scannerArray});
    }

    public Reflections(Object ... objectArray) {
        this(ConfigurationBuilder.build(objectArray));
    }

    protected Reflections() {
        this.configuration = new ConfigurationBuilder();
        this.store = new Store();
    }

    protected void scan() {
        if (this.configuration.getUrls() == null || this.configuration.getUrls().isEmpty()) {
            if (log != null) {
                log.warn("given scan urls are empty. set urls in the configuration");
            }
            return;
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug("going to scan these urls: {}", this.configuration.getUrls());
        }
        long l = System.currentTimeMillis();
        int n = 0;
        ExecutorService executorService = this.configuration.getExecutorService();
        ArrayList arrayList = new ArrayList();
        for (URL object : this.configuration.getUrls()) {
            try {
                if (executorService != null) {
                    arrayList.add(executorService.submit(() -> {
                        if (log != null) {
                            log.debug("[{}] scanning {}", (Object)Thread.currentThread().toString(), (Object)object);
                        }
                        this.scan(object);
                    }));
                } else {
                    this.scan(object);
                }
                ++n;
            }
            catch (ReflectionsException reflectionsException) {
                if (log == null) continue;
                log.warn("could not create Vfs.Dir from url. ignoring the exception and continuing", (Throwable)reflectionsException);
            }
        }
        if (executorService != null) {
            for (Future future : arrayList) {
                try {
                    future.get();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        if (executorService != null) {
            executorService.shutdown();
        }
        if (log != null) {
            log.info(String.format("Reflections took %d ms to scan %d urls, producing %s %s", System.currentTimeMillis() - l, n, Reflections.producingDescription(this.store), executorService instanceof ThreadPoolExecutor ? String.format("[using %d cores]", ((ThreadPoolExecutor)executorService).getMaximumPoolSize()) : ""));
        }
    }

    private static String producingDescription(Store store) {
        int n = 0;
        int n2 = 0;
        for (String string : store.keySet()) {
            n += store.keys(string).size();
            n2 += store.values(string).size();
        }
        return String.format("%d keys and %d values", n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(URL uRL) {
        try (Vfs.Dir dir = Vfs.fromURL(uRL);){
            for (Vfs.File file : dir.getFiles()) {
                Predicate<String> predicate = this.configuration.getInputsFilter();
                String string = file.getRelativePath();
                String string2 = string.replace('/', '.');
                if (predicate != null && !predicate.test(string) && !predicate.test(string2)) continue;
                Object object = null;
                for (Scanner scanner : this.configuration.getScanners()) {
                    try {
                        if (!scanner.acceptsInput(string) && !scanner.acceptsInput(string2)) continue;
                        object = scanner.scan(file, object, this.store);
                    }
                    catch (Exception exception) {
                        if (log == null) continue;
                        log.debug("could not scan file {} in url {} with scanner {}", new Object[]{file.getRelativePath(), uRL.toExternalForm(), scanner.getClass().getSimpleName(), exception});
                    }
                }
            }
        }
    }

    public static Reflections collect() {
        return Reflections.collect("META-INF/reflections/", new FilterBuilder().include(".*-reflections.xml"), new Serializer[0]);
    }

    public static Reflections collect(String string, Predicate<String> predicate, Serializer ... serializerArray) {
        XmlSerializer xmlSerializer = serializerArray != null && serializerArray.length == 1 ? serializerArray[0] : new XmlSerializer();
        Collection<URL> collection = ClasspathHelper.forPackage(string, new ClassLoader[0]);
        if (collection.isEmpty()) {
            return null;
        }
        long l = System.currentTimeMillis();
        Reflections reflections = new Reflections();
        Iterable<Vfs.File> iterable = Vfs.findFiles(collection, string, predicate);
        for (Vfs.File file : iterable) {
            InputStream inputStream = null;
            try {
                inputStream = file.openInputStream();
                reflections.merge(xmlSerializer.read(inputStream));
            }
            catch (IOException iOException) {
                throw new ReflectionsException("could not merge " + file, iOException);
            }
            finally {
                Utils.close(inputStream);
            }
        }
        if (log != null) {
            log.info(String.format("Reflections took %d ms to collect %d url, producing %s", System.currentTimeMillis() - l, collection.size(), Reflections.producingDescription(reflections.store)));
        }
        return reflections;
    }

    public Reflections collect(InputStream inputStream) {
        try {
            this.merge(this.configuration.getSerializer().read(inputStream));
            if (log != null) {
                log.info("Reflections collected metadata from input stream using serializer " + this.configuration.getSerializer().getClass().getName());
            }
        }
        catch (Exception exception) {
            throw new ReflectionsException("could not merge input stream", exception);
        }
        return this;
    }

    public Reflections collect(File file) {
        Reflections reflections;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            reflections = this.collect(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new ReflectionsException("could not obtain input stream from file " + file, fileNotFoundException);
            }
            catch (Throwable throwable) {
                Utils.close(fileInputStream);
                throw throwable;
            }
        }
        Utils.close(fileInputStream);
        return reflections;
    }

    public Reflections merge(Reflections reflections) {
        this.store.merge(reflections.store);
        return this;
    }

    public void expandSuperTypes() {
        String string = Utils.index(SubTypesScanner.class);
        Set<String> set = this.store.keys(string);
        set.removeAll(this.store.values(string));
        for (String string2 : set) {
            Class<?> clazz = ReflectionUtils.forName(string2, this.loaders());
            if (clazz == null) continue;
            this.expandSupertypes(this.store, string2, clazz);
        }
    }

    private void expandSupertypes(Store store, String string, Class<?> clazz) {
        for (Class<?> clazz2 : ReflectionUtils.getSuperTypes(clazz)) {
            if (!store.put(SubTypesScanner.class, clazz2.getName(), string)) continue;
            if (log != null) {
                log.debug("expanded subtype {} -> {}", (Object)clazz2.getName(), (Object)string);
            }
            this.expandSupertypes(store, clazz2.getName(), clazz2);
        }
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> clazz) {
        return ReflectionUtils.forNames(this.store.getAll(SubTypesScanner.class, clazz.getName()), this.loaders());
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> clazz) {
        return this.getTypesAnnotatedWith(clazz, false);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> clazz, boolean bl) {
        Set<String> set = this.store.get(TypeAnnotationsScanner.class, clazz.getName());
        set.addAll(this.getAllAnnotated(set, clazz, bl));
        return ReflectionUtils.forNames(set, this.loaders());
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation) {
        return this.getTypesAnnotatedWith(annotation, false);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation, boolean bl) {
        Set<String> set = this.store.get(TypeAnnotationsScanner.class, annotation.annotationType().getName());
        Set<Class<?>> set2 = Utils.filter(ReflectionUtils.forNames(set, this.loaders()), ReflectionUtils.withAnnotation(annotation));
        Set set3 = ReflectionUtils.forNames(Utils.filter(this.getAllAnnotated(Utils.names(set2), annotation.annotationType(), bl), string -> !set.contains(string)), this.loaders());
        set2.addAll(set3);
        return set2;
    }

    protected Collection<String> getAllAnnotated(Collection<String> collection, Class<? extends Annotation> clazz, boolean bl) {
        if (bl) {
            if (clazz.isAnnotationPresent(Inherited.class)) {
                Set<String> set = this.store.get(SubTypesScanner.class, Utils.filter(collection, string -> {
                    Class<?> clazz = ReflectionUtils.forName(string, this.loaders());
                    return clazz != null && !clazz.isInterface();
                }));
                return this.store.getAllIncluding(SubTypesScanner.class, set);
            }
            return collection;
        }
        Set<String> set = this.store.getAllIncluding(TypeAnnotationsScanner.class, collection);
        return this.store.getAllIncluding(SubTypesScanner.class, set);
    }

    public Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> clazz) {
        return Utils.getMethodsFromDescriptors(this.store.get(MethodAnnotationsScanner.class, clazz.getName()), this.loaders());
    }

    public Set<Method> getMethodsAnnotatedWith(Annotation annotation) {
        return Utils.filter(this.getMethodsAnnotatedWith(annotation.annotationType()), ReflectionUtils.withAnnotation(annotation));
    }

    public Set<Method> getMethodsMatchParams(Class<?> ... classArray) {
        return Utils.getMethodsFromDescriptors(this.store.get(MethodParameterScanner.class, Utils.names(classArray).toString()), this.loaders());
    }

    public Set<Method> getMethodsReturn(Class clazz) {
        return Utils.getMethodsFromDescriptors(this.store.get(MethodParameterScanner.class, Utils.names(clazz)), this.loaders());
    }

    public Set<Method> getMethodsWithAnyParamAnnotated(Class<? extends Annotation> clazz) {
        return Utils.getMethodsFromDescriptors(this.store.get(MethodParameterScanner.class, clazz.getName()), this.loaders());
    }

    public Set<Method> getMethodsWithAnyParamAnnotated(Annotation annotation) {
        return Utils.filter(this.getMethodsWithAnyParamAnnotated(annotation.annotationType()), ReflectionUtils.withAnyParameterAnnotation(annotation));
    }

    public Set<Constructor> getConstructorsAnnotatedWith(Class<? extends Annotation> clazz) {
        return Utils.getConstructorsFromDescriptors(this.store.get(MethodAnnotationsScanner.class, clazz.getName()), this.loaders());
    }

    public Set<Constructor> getConstructorsAnnotatedWith(Annotation annotation) {
        return Utils.filter(this.getConstructorsAnnotatedWith(annotation.annotationType()), ReflectionUtils.withAnnotation(annotation));
    }

    public Set<Constructor> getConstructorsMatchParams(Class<?> ... classArray) {
        return Utils.getConstructorsFromDescriptors(this.store.get(MethodParameterScanner.class, Utils.names(classArray).toString()), this.loaders());
    }

    public Set<Constructor> getConstructorsWithAnyParamAnnotated(Class<? extends Annotation> clazz) {
        return Utils.getConstructorsFromDescriptors(this.store.get(MethodParameterScanner.class, clazz.getName()), this.loaders());
    }

    public Set<Constructor> getConstructorsWithAnyParamAnnotated(Annotation annotation) {
        return Utils.filter(this.getConstructorsWithAnyParamAnnotated(annotation.annotationType()), ReflectionUtils.withAnyParameterAnnotation(annotation));
    }

    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> clazz) {
        return this.store.get(FieldAnnotationsScanner.class, clazz.getName()).stream().map(string -> Utils.getFieldFromString(string, this.loaders())).collect(Collectors.toSet());
    }

    public Set<Field> getFieldsAnnotatedWith(Annotation annotation) {
        return Utils.filter(this.getFieldsAnnotatedWith(annotation.annotationType()), ReflectionUtils.withAnnotation(annotation));
    }

    public Set<String> getResources(Predicate<String> predicate) {
        Set<String> set = Utils.filter(this.store.keys(Utils.index(ResourcesScanner.class)), predicate);
        return this.store.get(ResourcesScanner.class, set);
    }

    public Set<String> getResources(Pattern pattern) {
        return this.getResources((String string) -> pattern.matcher((CharSequence)string).matches());
    }

    public List<String> getMethodParamNames(Method method) {
        Set<String> set = this.store.get(MethodParameterNamesScanner.class, Utils.name(method));
        return set.size() == 1 ? Arrays.asList(set.iterator().next().split(", ")) : Collections.emptyList();
    }

    public List<String> getConstructorParamNames(Constructor constructor) {
        Set<String> set = this.store.get(MethodParameterNamesScanner.class, Utils.name(constructor));
        return set.size() == 1 ? Arrays.asList(set.iterator().next().split(", ")) : Collections.emptyList();
    }

    public Set<Member> getFieldUsage(Field field) {
        return Utils.getMembersFromDescriptors(this.store.get(MemberUsageScanner.class, Utils.name(field)), new ClassLoader[0]);
    }

    public Set<Member> getMethodUsage(Method method) {
        return Utils.getMembersFromDescriptors(this.store.get(MemberUsageScanner.class, Utils.name(method)), new ClassLoader[0]);
    }

    public Set<Member> getConstructorUsage(Constructor constructor) {
        return Utils.getMembersFromDescriptors(this.store.get(MemberUsageScanner.class, Utils.name(constructor)), new ClassLoader[0]);
    }

    public Set<String> getAllTypes() {
        HashSet<String> hashSet = new HashSet<String>(this.store.getAll(SubTypesScanner.class, Object.class.getName()));
        if (hashSet.isEmpty()) {
            throw new ReflectionsException("Couldn't find subtypes of Object. Make sure SubTypesScanner initialized to include Object class - new SubTypesScanner(false)");
        }
        return hashSet;
    }

    public Store getStore() {
        return this.store;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public File save(String string) {
        return this.save(string, this.configuration.getSerializer());
    }

    public File save(String string, Serializer serializer) {
        File file = serializer.save(this, string);
        if (log != null) {
            log.info("Reflections successfully saved in " + file.getAbsolutePath() + " using " + serializer.getClass().getSimpleName());
        }
        return file;
    }

    private ClassLoader[] loaders() {
        return this.configuration.getClassLoaders();
    }
}

