/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.reflections.ReflectionsException;
import org.reflections.util.Utils;

public class Store {
    private final ConcurrentHashMap<String, Map<String, Collection<String>>> storeMap = new ConcurrentHashMap();

    protected Store() {
    }

    public Set<String> keySet() {
        return this.storeMap.keySet();
    }

    private Map<String, Collection<String>> get(String string) {
        Map<String, Collection<String>> map = this.storeMap.get(string);
        if (map == null) {
            throw new ReflectionsException("Scanner " + string + " was not configured");
        }
        return map;
    }

    public Set<String> get(Class<?> clazz, String string) {
        return this.get(Utils.index(clazz), Collections.singletonList(string));
    }

    public Set<String> get(String string, String string2) {
        return this.get(string, Collections.singletonList(string2));
    }

    public Set<String> get(Class<?> clazz, Collection<String> collection) {
        return this.get(Utils.index(clazz), collection);
    }

    private Set<String> get(String string, Collection<String> collection) {
        Map<String, Collection<String>> map = this.get(string);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string2 : collection) {
            Collection<String> collection2 = map.get(string2);
            if (collection2 == null) continue;
            linkedHashSet.addAll(collection2);
        }
        return linkedHashSet;
    }

    public Set<String> getAllIncluding(Class<?> clazz, Collection<String> collection) {
        String string = Utils.index(clazz);
        Map<String, Collection<String>> map = this.get(string);
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Collection<String> collection2;
            String string2 = (String)arrayList.get(i);
            if (!hashSet.add(string2) || (collection2 = map.get(string2)) == null) continue;
            arrayList.addAll(collection2);
        }
        return hashSet;
    }

    public Set<String> getAll(Class<?> clazz, String string) {
        return this.getAllIncluding(clazz, this.get(clazz, string));
    }

    public Set<String> getAll(Class<?> clazz, Collection<String> collection) {
        return this.getAllIncluding(clazz, this.get(clazz, collection));
    }

    public Set<String> keys(String string) {
        Map<String, Collection<String>> map = this.storeMap.get(string);
        return map != null ? new HashSet<String>(map.keySet()) : Collections.emptySet();
    }

    public Set<String> values(String string) {
        Map<String, Collection<String>> map = this.storeMap.get(string);
        return map != null ? map.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public boolean put(Class<?> clazz, String string, String string2) {
        return this.put(Utils.index(clazz), string, string2);
    }

    public boolean put(String string2, String string3, String string4) {
        return this.storeMap.computeIfAbsent(string2, string -> new ConcurrentHashMap()).computeIfAbsent(string3, string -> new ArrayList()).add(string4);
    }

    void merge(Store store) {
        if (store != null) {
            for (String string : store.keySet()) {
                Map<String, Collection<String>> map = store.get(string);
                if (map == null) continue;
                for (String string2 : map.keySet()) {
                    for (String string3 : map.get(string2)) {
                        this.put(string, string2, string3);
                    }
                }
            }
        }
    }
}

